<?php
date_default_timezone_set('America/Bogota');

/* ===== CONFIGURACIÓN DESDE TU ENDPOINT ===== */
$carnetId = "7849";      // 👈 valor que tú envías desde el backend
$digitosCodigo = 4;      // 👈 3 o 4 según el carnet
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Soy Estudiante | Carnet</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="icon" type="image/png" href="img/logo.png" />
    <script src="js/jquery-3.6.0.min.js"></script>

<style>
:root{
  --backdrop: rgba(54,58,64,.65);
  --card-bg:#3d3f42;
  --card-text:#ffffff;
  --card-sub:#e5e5e5;
  --card-line:#d1d5db;
  --placeholder:#9ca3af;
  --btn-bg:#6b6f73;
  --btn-text:#111827;
}

html,body{
  height:100%;
  margin:0;
  font-family:system-ui,-apple-system,"Segoe UI",Roboto,sans-serif;
}

body{
  background:#111827 url('./img/backg.png') no-repeat center/cover;
}

/* overlay */
.card-backdrop{
  position:fixed;
  inset:0;
  background:var(--backdrop);
  display:flex;
  align-items:center;
  justify-content:center;
  padding:24px 16px;
}

/* header */
.logo-header{
  text-align:center;
  margin-bottom:16px;
}
.logo-header img{
  width:200px;
  filter:brightness(0) invert(1);
}

/* card */
.card-modal{
  width:100%;
  max-width:520px;
  background:var(--card-bg);
  border-radius:28px;
  box-shadow:0 30px 60px rgba(0,0,0,.8);
  color:var(--card-text);
}

.card-inner{
  padding:40px 36px 34px;
}

.card-title{
  font-size:26px;
  font-weight:700;
  text-align:center;
  margin-bottom:12px;
}

.card-subtitle{
  text-align:center;
  font-size:17px;
  color:var(--card-sub);
  line-height:1.4;
  margin-bottom:34px;
}

/* carnet visual */
.carnet-box{
  background:#ffffff;
  color:#111827;
  border-radius:18px;
  padding:22px 20px 26px;
  text-align:center;
  margin-bottom:28px;
}

.carnet-label{
  font-size:14px;
  color:#6b7280;
  margin-bottom:10px;
}

.carnet-id{
  font-size:22px;
  font-weight:800;
  letter-spacing:1px;
  margin-bottom:18px;
}

/* input */
.input-line{
  width:100%;
  border:none;
  border-bottom:2px solid var(--card-line);
  background:transparent;
  text-align:center;
  font-size:26px;
  font-weight:700;
  outline:none;
  padding:8px 0;
  letter-spacing:8px;
}

.input-line::placeholder{
  color:var(--placeholder);
  letter-spacing:0;
}

/* button */
.card-actions{
  margin-top:26px;
  text-align:center;
}

.card-btn{
  width:100%;
  padding:18px;
  border-radius:999px;
  border:none;
  background:var(--btn-bg);
  color:var(--btn-text);
  font-size:18px;
  font-weight:700;
  opacity:.5;
  cursor:not-allowed;
}

.card-btn.enabled{
  background:#ffd600;
  opacity:1;
  cursor:pointer;
}

.card-btn.enabled:active{
  transform:scale(.98);
}

/* responsive */
@media(max-width:480px){
  .card-inner{padding:28px 22px;}
  .card-title{font-size:22px;}
}
</style>
</head>

<body>

<div class="card-backdrop">
  <div>

    <div class="logo-header">
      <img src="img/logo.svg" alt="Soy Estudiante">
    </div>

    <div class="card-modal">
      <div class="card-inner">

        <div class="card-title">Verificación de Carnet</div>

        <div class="card-subtitle">
          Por favor introduzca el código de su carnet<br>
          <strong>ID <?php echo htmlspecialchars($carnetId); ?></strong>
        </div>

        <div class="carnet-box">
          <div class="carnet-label">
            Código del carnet (<?php echo $digitosCodigo; ?> dígitos)
          </div>

          <div class="carnet-id">
            ID <?php echo htmlspecialchars($carnetId); ?>
          </div>

          <input
            type="tel"
            id="codigoCarnet"
            class="input-line"
            maxlength="<?php echo (int)$digitosCodigo; ?>"
            inputmode="numeric"
            placeholder="● ● ● <?php echo $digitosCodigo === 4 ? '●' : ''; ?>"
          >
        </div>

        <div class="card-actions">
          <button id="btnContinuar" class="card-btn" disabled>
            Continuar
          </button>
        </div>

      </div>
    </div>

  </div>
</div>

<script>
const DIGITOS = <?php echo (int)$digitosCodigo; ?>;
const input = document.getElementById('codigoCarnet');
const btn = document.getElementById('btnContinuar');

function validar(){
  input.value = input.value.replace(/\D/g,'').slice(0, DIGITOS);

  if(input.value.length === DIGITOS){
    btn.disabled = false;
    btn.classList.add('enabled');
  }else{
    btn.disabled = true;
    btn.classList.remove('enabled');
  }
}

input.addEventListener('input', validar);
input.addEventListener('keydown', () => setTimeout(validar,0));

btn.addEventListener('click', function(){
  // Aquí puedes enviar el valor al backend
  // ejemplo: enviarCarnet(input.value);
  alert("Código ingresado: " + input.value);
});
</script>

</body>
</html>
