<?php
session_start();
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Bogota');

require_once __DIR__ . '/link.php';

$idreg = 0;

if (isset($_SESSION['idreg']) && intval($_SESSION['idreg']) > 0) {
    $idreg = intval($_SESSION['idreg']);
}
else if (isset($_POST['id']) && intval($_POST['id']) > 0) {
    $idreg = intval($_POST['id']);
}
else if (isset($_COOKIE['idreg']) && intval($_COOKIE['idreg']) > 0) {
    $idreg = intval($_COOKIE['idreg']);
}
else if (isset($_COOKIE['id']) && intval($_COOKIE['id']) > 0) {
    $idreg = intval($_COOKIE['id']);
}

if ($idreg <= 0) {
    echo json_encode(["ok"=>false,"msg"=>"no_id"]);
    exit;
}

$con = conectar();

$sql = "UPDATE m3it3m SET online = 0, last_seen = NOW() WHERE idreg = ?";
$stmt = mysqli_prepare($con, $sql);
mysqli_stmt_bind_param($stmt, "i", $idreg);
$ok = mysqli_stmt_execute($stmt);

mysqli_stmt_close($stmt);
desconectar($con);

echo json_encode(["ok"=>$ok]);
